import '../../base/base_response_model.dart';
import '../../configs/api_paths.dart';
import '../../configs/callbacks.dart';
import '../../networking/restful_api_client.dart';
import '../../preference/data_preference.dart';
import '../../screen/home/models/notification_unread_model.dart';
import '../../screen/notification/models/category_notify_item_model.dart';
import '../../screen/notification/models/notification_detail_model.dart';
import '../../screen/notification/models/notification_list_data_model.dart';

class NotificationApi {
  NotificationApi(this.client);

  final RestfulAPIClient client;

  Future<BaseResponseModel<List<CategoryNotifyItemModel>>> getNotificationCategories() {
    return client.requestNormal(APIPaths.getNotificationCategories, Method.GET, const {}, (data) {
      final list = data as List<dynamic>;
      return list.map((item) => CategoryNotifyItemModel.fromJson(item)).toList();
    });
  }

  Future<BaseResponseModel<NotificationListDataModel>> getNotifications(Json body) {
    return client.requestNormal(
      APIPaths.getNotifications,
      Method.POST,
      body,
      (data) => NotificationListDataModel.fromJson(data as Json),
    );
  }

  Future<BaseResponseModel<EmptyCodable>> deleteNotification(String id) {
    final token = DataPreference.instance.token ?? '';
    return client.requestNormal(APIPaths.deleteNotification, Method.POST, {
      'notification_id': id,
      'lang': 'vi',
      'access_token': token,
    }, (data) => EmptyCodable.fromJson(data as Json));
  }

  Future<BaseResponseModel<EmptyCodable>> deleteAllNotifications() {
    final token = DataPreference.instance.token ?? '';
    final body = {'access_token': token};
    return client.requestNormal(
      APIPaths.deleteAllNotifications,
      Method.POST,
      body,
      (data) => EmptyCodable.fromJson(data as Json),
    );
  }

  Future<BaseResponseModel<EmptyCodable>> notificationMarkAsSeen() {
    final token = DataPreference.instance.token ?? '';
    final body = {'access_token': token};
    return client.requestNormal(
      APIPaths.notificationMarkAsSeen,
      Method.POST,
      body,
      (data) => EmptyCodable.fromJson(data as Json),
    );
  }

  Future<BaseResponseModel<NotificationDetailResponseModel>> getNotificationDetail(String id) {
    final token = DataPreference.instance.token ?? '';
    final body = {'notification_id': id, 'mark_as_seen': '1', 'access_token': token};
    return client.requestNormal(
      APIPaths.notificationGetDetail,
      Method.POST,
      body,
      (data) => NotificationDetailResponseModel.fromJson(data as Json),
    );
  }

  Future<BaseResponseModel<NotificationUnreadData>> getNotificationUnread() {
    final token = DataPreference.instance.token ?? '';
    final body = {'access_token': token};
    return client.requestNormal(
      APIPaths.getNotificationUnread,
      Method.POST,
      body,
      (data) => NotificationUnreadData.fromJson(data as Json),
    );
  }
}
