import '../../base/base_response_model.dart';
import '../../configs/api_paths.dart';
import '../../configs/callbacks.dart';
import '../../networking/restful_api_client.dart';
import '../../preference/data_preference.dart';
import '../../screen/faqs/faqs_model.dart';
import '../../screen/pageDetail/model/campaign_detail_model.dart';
import '../../screen/pageDetail/model/detail_page_rule_type.dart';

class WebsiteApi {
  WebsiteApi(this.client);

  final RestfulAPIClient client;

  Future<BaseResponseModel<CampaignDetailResponseModel>> websitePageGetDetail(String id) {
    final token = DataPreference.instance.token ?? '';
    final body = {'website_page_id': id, 'access_token': token};
    return client.requestNormal(
      APIPaths.websitePageGetDetail,
      Method.POST,
      body,
      (data) => CampaignDetailResponseModel.fromJson(data as Json),
    );
  }

  Future<BaseResponseModel<CampaignDetailResponseModel>> websitePage(DetailPageRuleType rule) {
    final body = {'code': rule.key};
    return client.requestNormal(
      APIPaths.websitePage,
      Method.GET,
      body,
      (data) => CampaignDetailResponseModel.fromJson(data as Json),
    );
  }

  Future<BaseResponseModel<FAQItemModelResponse>> websiteFolderGetPageList(Json body) {
    return client.requestNormal(
      APIPaths.websiteFolderGetPageList,
      Method.POST,
      body,
      (data) => FAQItemModelResponse.fromJson(data as Json),
    );
  }
}
