import 'package:flutter/foundation.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mypoint_flutter_app/widgets/custom_empty_widget.dart';
import 'package:mypoint_flutter_app/widgets/image_loader.dart';
import '../../widgets/custom_navigation_bar.dart';
import 'bank_account_detail_screen.dart';
import 'bank_account_info_model.dart';
import 'bank_account_manager_viewmodel.dart';

class BankAccountManagerScreen extends StatefulWidget {
  const BankAccountManagerScreen({super.key});

  @override
  State<BankAccountManagerScreen> createState() => _BankAccountManagerScreenState();
}

class _BankAccountManagerScreenState extends State<BankAccountManagerScreen> {
  final BankAccountManagerViewModel viewModel = Get.put(BankAccountManagerViewModel());

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: CustomNavigationBar(title: 'Quản lý tài khoản/ thẻ'),
      body: Obx(() {
        if (viewModel.bankAccounts.isEmpty) {
          return EmptyWidget(content: "Bạn hiện chưa có tài khoản/ thẻ đã lưu");
        }
        return Container(
          color: const Color(0xfff9fafb),
          child: ListView.separated(
            padding: const EdgeInsets.symmetric(vertical: 8),
            itemCount: viewModel.bankAccounts.length,
            separatorBuilder: (_, __) => const Divider(height: 1, thickness: 1),
            itemBuilder: (item, index) => _BankAccountItem(model: viewModel.bankAccounts.value[index], onTap: () async {
             await Get.to(() => BankAccountDetailScreen(
                model: viewModel.bankAccounts.value[index],
              ));
             debugPrint("reload getBankAccountList");
             viewModel.getBankAccountList();
            }),
          ),
        );
      }),
    );
  }
}

class _BankAccountItem extends StatelessWidget {
  final BankAccountInfoModel model;
  final VoidCallback? onTap;
  const _BankAccountItem({required this.model, this.onTap});

  @override
  Widget build(BuildContext context) {
    return Material(
      color: Colors.white,
      child: InkWell(
        onTap: onTap,
        child: Column(
          children: [
            Padding(
              padding: const EdgeInsets.symmetric(horizontal: 16, vertical: 16),
              child: Row(
                children: [
                  ClipRRect(
                    borderRadius: BorderRadius.circular(4),
                    child: loadNetworkImage(url: model.bankLogo, width: 32, height: 32),
                  ),
                  const SizedBox(width: 12),
                  Expanded(
                    child: Row(
                      children: [
                        Text(
                          '${model.bankShortName} ${model.cardNumber}',
                          maxLines: 1,
                          overflow: TextOverflow.ellipsis,
                          style: const TextStyle(fontSize: 15, color: Color(0xFF1D2129), fontWeight: FontWeight.w500),
                        ),
                        if (model.isDefault == true) ...[const SizedBox(width: 8), const _DefaultBadge()],
                      ],
                    ),
                  ),
                  const Icon(Icons.chevron_right, color: Color(0xFF8B8E95)),
                ],
              ),
            ),
            Padding(
              padding: const EdgeInsets.symmetric(horizontal: 16),
              child: Divider(
                height: 1,
                thickness: 1,
                color: const Color(0xFFEBEDF0),
              ),
            ),
          ],
        ),
      ),
    );
  }
}

class _DefaultBadge extends StatelessWidget {
  const _DefaultBadge();

  @override
  Widget build(BuildContext context) {
    return Container(
      padding: const EdgeInsets.symmetric(horizontal: 6, vertical: 2),
      decoration: BoxDecoration(color: const Color(0xFFFFE9EA), borderRadius: BorderRadius.circular(16)),
      child: const Text(
        ' Mặc định ',
        style: TextStyle(fontSize: 11, color: Color(0xFFEB4B54), fontWeight: FontWeight.w600),
      ),
    );
  }
}
