import 'package:flutter/material.dart';
import 'package:flutter_widget_from_html_core/flutter_widget_from_html_core.dart';
import '../../resources/base_color.dart';
import 'models/campaign_7day_mission_model.dart';

class Campaign7DayMissionInfoDialog extends StatelessWidget {
  final Campaign7DayMissionModel mission;
  final VoidCallback onConfirm;
  final VoidCallback onClose;

  const Campaign7DayMissionInfoDialog({
    super.key,
    required this.mission,
    required this.onConfirm,
    required this.onClose,
  });

  @override
  Widget build(BuildContext context) {
    return Stack(children: [_buildContentBox(), _buildCloseButton()]);
  }

  Widget _buildContentBox() {
    return Container(
      padding: const EdgeInsets.only(top: 24),
      child: Stack(clipBehavior: Clip.none, children: [_buildInnerContainer(), _buildHeaderBanner()]),
    );
  }

  Widget _buildInnerContainer() {
    return Container(
      margin: const EdgeInsets.only(top: 9, left: 8, right: 8),
      padding: const EdgeInsets.only(top: 16, left: 16, right: 16, bottom: 32),
      decoration: BoxDecoration(color: const Color(0xFFFEF1F2), borderRadius: BorderRadius.circular(16)),
      child: Column(
        mainAxisSize: MainAxisSize.min,
        children: [
          const SizedBox(height: 36),
          HtmlWidget(mission.info ?? '', textStyle: const TextStyle(fontSize: 16, color: Colors.black87)),
          const SizedBox(height: 36),
          if (mission.isReady) _buildConfirmButton(),
        ],
      ),
    );
  }

  Widget _buildHeaderBanner() {
    return Positioned(
      top: 0,
      left: 0,
      right: 0,
      child: Center(
        child: Stack(
          alignment: Alignment.center,
          children: [
            Image.asset('assets/images/ic_header_alert_campaign.png', height: 48, fit: BoxFit.contain),
            const Text(
              'Thông tin nhiệm vụ',
              style: TextStyle(
                color: Colors.white,
                fontWeight: FontWeight.w800,
                fontSize: 17,
                shadows: [Shadow(color: Colors.black26, offset: Offset(2, 2), blurRadius: 2)],
              ),
            ),
          ],
        ),
      ),
    );
  }

  Widget _buildCloseButton() {
    return Positioned(
      top: 0,
      right: 8,
      child: GestureDetector(
        onTap: onClose,
        child: Container(
          padding: const EdgeInsets.all(2),
          decoration: const BoxDecoration(
            shape: BoxShape.circle,
            border: Border.fromBorderSide(BorderSide(color: Colors.white, width: 1.5)),
          ),
          child: const Icon(Icons.close_outlined, color: Colors.white, size: 20),
        ),
      ),
    );
  }

  Widget _buildConfirmButton() {
    return ElevatedButton(
      onPressed: onConfirm,
      style: ElevatedButton.styleFrom(
        backgroundColor: BaseColor.primary400,
        minimumSize: const Size(double.infinity, 48),
        shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(24)),
      ),
      child: const Text('THỰC HIỆN', style: TextStyle(fontWeight: FontWeight.w800, color: Colors.white, fontSize: 18)),
    );
  }
}
