import 'package:json_annotation/json_annotation.dart';
import '../../../directional/directional_screen.dart';
import '../../../widgets/alert/popup_data_model.dart';
import 'campaign_7day_config_model.dart';
import 'campaign_7day_reward_model.dart';

part 'campaign_7day_mission_model.g.dart';
@JsonSerializable()
class Campaign7DayMissionModel {
  final int id;
  final String? title;
  final String? description;
  final String? info;
  final String? avatar;
  @JsonKey(name: 'title_button_action')
  final String? titleButtonAction;
  @JsonKey(name: 'type')
  final String? type;
  @JsonKey(name: 'status')
  final String? status;
  final Campaign7DayRewardModel? reward;
  @JsonKey(name: 'click_action_param')
  final String? clickActionParam;
  @JsonKey(name: 'click_action_type')
  final String? clickActionType;
  final PopupDataModel? popup;

  Campaign7DayMissionModel({
    required this.id,
    this.title,
    this.description,
    this.info,
    this.avatar,
    this.titleButtonAction,
    this.type,
    this.status,
    this.reward,
    this.clickActionParam,
    this.clickActionType,
    this.popup,
  });

  bool get isSpecial => type == "special";

  MissionStatus get mStatus =>
      MissionStatus.values.firstWhere((e) => e.name.toUpperCase() == status?.toUpperCase(), orElse: () => MissionStatus.pending);

  bool get isReady => mStatus == MissionStatus.ready;

  DirectionalScreen? get directionScreen =>
      (clickActionType != null && clickActionParam != null)
          ? DirectionalScreen.build(clickActionType: clickActionType!, clickActionParam: clickActionParam!)
          : null;

  factory Campaign7DayMissionModel.fromJson(Map<String, dynamic> json) =>
      _$Campaign7DayMissionModelFromJson(json);
  Map<String, dynamic> toJson() => _$Campaign7DayMissionModelToJson(this);
}