import 'package:flutter/material.dart';
import 'package:get/get.dart';
import '../../base/base_screen.dart';
import '../../base/basic_state.dart';
import '../../resources/base_color.dart';
import '../../widgets/custom_navigation_bar.dart';
import 'electric_payment_viewmodel.dart';

class ElectricPaymentScreen extends BaseScreen {
  const ElectricPaymentScreen({super.key});

  @override
  State<ElectricPaymentScreen> createState() => _ElectricPaymentScreenState();
}

class _ElectricPaymentScreenState extends BaseState<ElectricPaymentScreen> with BasicState {
  final ElectricPaymentViewModel _viewModel = Get.put(ElectricPaymentViewModel());
  final TextEditingController _controller = TextEditingController();
  bool _canContinue = false;

  @override
  void initState() {
    super.initState();
    _controller.addListener(() {
      setState(() {
        _canContinue = _controller.text.isNotEmpty;
      });
    });

    _viewModel.onShowAlertError = (message) {
      if (message.isNotEmpty) {
        showAlertError(content: message);
      }
    };
  }

  @override
  void dispose() {
    _controller.dispose();
    super.dispose();
  }

  @override
  Widget createBody() {
    return Scaffold(
      appBar: CustomNavigationBar(title: 'Thêm hoá đơn điện'),
      body: SingleChildScrollView(
        padding: const EdgeInsets.all(16),
        child: Column(
          children: [
            const SizedBox(height: 32),
            Image.asset('assets/images/ic_evn_logo.png', height: 80),
            const SizedBox(height: 8),
            const Text(
              'Điện lực Việt Nam - EVN',
              style: TextStyle(fontSize: 18, color: Colors.blueAccent, fontWeight: FontWeight.bold),
            ),
            const SizedBox(height: 32),
            TextField(
              controller: _controller,
              decoration: InputDecoration(
                labelText: 'Mã khách hàng',
                border: const UnderlineInputBorder(),
                suffixIcon: _controller.text.isNotEmpty
                    ? IconButton(
                  icon: const Icon(Icons.clear_rounded, color: Colors.grey),
                  onPressed: () {
                    _controller.clear();
                    setState(() {
                      _canContinue = false;
                    });
                  },
                )
                    : null,
              ),
            ),
            const SizedBox(height: 24),
            ElevatedButton(
              onPressed: _canContinue ? () {
                final code = _controller.text.trim();
                if (code.isEmpty) return;
                _viewModel.customerContractRequestSearch(code);
              } : null,
              style: ElevatedButton.styleFrom(
                backgroundColor: BaseColor.primary500,
                minimumSize: const Size(double.infinity, 48),
              ),
              child: const Text(
                'Tiếp tục',
                style: TextStyle(fontWeight: FontWeight.bold, color: Colors.white, fontSize: 16),
              ),
            ),
            const SizedBox(height: 12),
            Divider(color: Colors.grey.shade300, thickness: 1, height: 32),
            const SizedBox(height: 12),
            Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Text('Hướng dẫn lấy mã khách hàng', style: TextStyle(fontSize: 16, fontWeight: FontWeight.bold)),
                const SizedBox(height: 8),
                Text('Bạn có thể tìm thấy mã khách hàng tại Hóa đơn tiền điện:'),
              ],
            ),
            const SizedBox(height: 16),
            Image.asset('assets/images/ic_electric_tutorial.png', fit: BoxFit.cover),
          ],
        ),
      ),
    );
  }
}
