import 'package:flutter/material.dart';
import 'package:qr_flutter/qr_flutter.dart';

void showPopupInviteFriendCode(BuildContext context, String qrString) {
  final width = MediaQuery.of(context).size.width;
  showModalBottomSheet(
    context: context,
    isScrollControlled: true,
    backgroundColor: Colors.white,
    shape: const RoundedRectangleBorder(borderRadius: BorderRadius.vertical(top: Radius.circular(16))),
    builder: (_) {
      return SafeArea(
        child: SingleChildScrollView(
          child: Padding(
            padding: EdgeInsets.only(
              bottom: MediaQuery.of(context).viewInsets.bottom,
            ),
            child: Column(
              mainAxisSize: MainAxisSize.min,
              children: [
                Padding(
                  padding: const EdgeInsets.symmetric(horizontal: 16, vertical: 16),
                  child: Row(
                    mainAxisAlignment: MainAxisAlignment.end,
                    children: [
                      const Expanded(
                        child: Center(
                          child: Text(
                            'Rủ bạn nhập hội, nhận quà cả đôi!',
                            style: TextStyle(fontWeight: FontWeight.bold, fontSize: 18),
                          ),
                        ),
                      ),
                      GestureDetector(
                        onTap: () => Navigator.of(context).pop(),
                        child: const Icon(Icons.close, size: 20),
                      ),
                    ],
                  ),
                ),
                const Divider(height: 1),
                Container(
                  width: double.infinity,
                  margin: const EdgeInsets.symmetric(horizontal: 16),
                  padding: const EdgeInsets.all(16),
                  decoration: BoxDecoration(
                    color: Colors.red.shade50,
                    borderRadius: BorderRadius.circular(12),
                  ),
                  child: Column(
                    mainAxisAlignment: MainAxisAlignment.center,
                    children: [
                      Image.asset('assets/images/ic_pipi_couple.png', height: 72),
                      const SizedBox(height: 16),
                      Container(
                        color: Colors.white,
                        child: QrImageView(
                          data: qrString,
                          version: QrVersions.auto,
                          size: width / 1.7,
                          embeddedImage: const AssetImage('assets/images/ic_logo.png'),
                          embeddedImageStyle: const QrEmbeddedImageStyle(size: Size(40, 40)),
                        ),
                      ),
                      const SizedBox(height: 8),
                      Row(
                        mainAxisAlignment: MainAxisAlignment.center,
                        children: const [
                          Icon(Icons.download_outlined, color: Colors.black54),
                          SizedBox(width: 4),
                          Text('Lưu ảnh'),
                        ],
                      ),
                      const SizedBox(height: 8),
                      const Text('Mã giới thiệu:'),
                      Text(
                        qrString,
                        style: const TextStyle(fontWeight: FontWeight.bold, color: Colors.red, fontSize: 18),
                      ),
                    ],
                  ),
                ),
              ],
            ),
          ),
        ),
      );
    },
  );
}
