import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:mypoint_flutter_app/extensions/datetime_extensions.dart';
import 'package:mypoint_flutter_app/extensions/string_extension.dart';
import '../../resources/base_color.dart';
import 'models/usable_voucher_model.dart';

class UsableMobileCardPopup extends StatelessWidget {
  final UsableVoucherModel usableVoucher;

  const UsableMobileCardPopup({super.key, required this.usableVoucher});

  @override
  Widget build(BuildContext context) {
    final String titleNonExpired = "Bạn đã đổi mã thẻ điện thoại thành công.";
    final String titleSuccess = "Bạn đã đổi mã thẻ điện thoại thành công. Giá trị tới ngày %@. Vui lòng sử dụng trước ngày hết hạn.";
    final expiredTime = (usableVoucher.expiredTime ?? "").toDate()?.toFormattedString() ?? "";
    final String content = expiredTime.isNotEmpty
        ? titleSuccess.replaceAll("%@", usableVoucher.expiredTime!)
        : titleNonExpired;
    return Dialog(
      shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(16)),
      child: Padding(
        padding: const EdgeInsets.all(16.0),
        child: Column(
          mainAxisSize: MainAxisSize.min,
          children: [
            Align(
              alignment: Alignment.topRight,
              child: GestureDetector(
                onTap: () => Navigator.of(context).pop(),
                child: const Icon(Icons.close, size: 24),
              ),
            ),
            Image.asset(
              'assets/images/ic_pipi_02.png',
              height: 200,
            ),
            const SizedBox(height: 8),
            Text(
              "Thành Công",
              style: const TextStyle(fontSize: 18, fontWeight: FontWeight.bold),
            ),
            const SizedBox(height: 8),
            Text(
              content,
              textAlign: TextAlign.center,
              style: const TextStyle(fontSize: 14, color: Colors.black87),
            ),
            const SizedBox(height: 16),
            Container(
              height: 48,
              decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(8),
                color: Colors.grey.shade200,
              ),
              padding: const EdgeInsets.symmetric(horizontal: 12, vertical: 12),
              child: Row(
                children: [
                  Expanded(
                    child: Text(
                      usableVoucher.codeSecret ?? '---',
                      style: const TextStyle(fontSize: 16),
                    ),
                  ),
                  GestureDetector(
                    onTap: () {
                      Clipboard.setData(
                        ClipboardData(text: usableVoucher.codeSecret ?? ''),
                      );
                      ScaffoldMessenger.of(context).showSnackBar(
                        const SnackBar(content: Text('Đã sao chép mã')),
                      );
                    },
                    child: const Icon(Icons.copy),
                  ),
                ],
              ),
            ),
            const SizedBox(height: 20),
            ElevatedButton(
              onPressed: () => Navigator.of(context).pop(),
              style: ElevatedButton.styleFrom(
                minimumSize: const Size(double.infinity, 48),
                backgroundColor: BaseColor.primary500,
                shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(8)),
              ),
              child: const Text("Đã hiểu", style: TextStyle(fontSize: 16, color: Colors.white, fontWeight: FontWeight.bold)),
            ),
          ],
        ),
      ),
    );
  }
}

void showVoucherPopup(BuildContext context, UsableVoucherModel usableVoucher) {
  showDialog(
    context: context,
    barrierDismissible: true,
    builder: (_) => UsableMobileCardPopup(usableVoucher: usableVoucher),
  );
}
