// setting_screen.dart
import 'package:flutter/foundation.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mypoint_flutter_app/screen/setting/setting_viewmodel.dart';
import '../../shared/router_gage.dart';
import '../../widgets/bottom_sheet_helper.dart';
import '../../widgets/custom_navigation_bar.dart';
import '../change_pass/change_pass_screen.dart';
import '../delete_account/delete_account_dialog.dart';

class SettingScreen extends StatefulWidget {
  const SettingScreen({super.key});

  @override
  State<SettingScreen> createState() => _SettingScreenState();
}

class _SettingScreenState extends State<SettingScreen> {
  final SettingViewModel viewModel = SettingViewModel();

  @override
  void initState() {
    super.initState();
    viewModel.loadBiometricStatus().then((enabled) {
      setState(() {
        viewModel.biometricEnabled = enabled;
      });
    });
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: CustomNavigationBar(title: "Cài đặt"),
      backgroundColor: const Color(0xFFF5F6F7),
      body: Column(
        children: [
          Container(
            width: double.infinity,
            margin: const EdgeInsets.symmetric(horizontal: 0, vertical: 0),
            decoration: BoxDecoration(
              color: Colors.white,
            ),
            child: Column(
              children: [
                _buildSettingItem(
                  icon: Icons.apps,
                  title: 'Các lĩnh vực quan tâm',
                  onTap: () {
                    Get.toNamed(interestCategoriesScreen);
                  },
                ),
                _buildDivider(),
                _buildSettingItem(
                  icon: Icons.lock_outline,
                  title: 'Đổi mật khẩu',
                  onTap: () => Get.to(ChangePassScreen()),
                ),
                _buildDivider(),
                if (!kIsWeb)
                  _buildSettingItem(
                    icon: Icons.fingerprint,
                    title: 'Xác thực sinh trắc học',
                    showTrailing: false,
                    trailing: Switch(
                      value: viewModel.biometricEnabled,
                      onChanged: (value) async {
                        final result = await viewModel.toggleBiometric(value);
                        setState(() {
                          viewModel.biometricEnabled = result;
                        });
                      },
                      activeColor: Colors.white,
                      activeTrackColor: Colors.green,
                      inactiveThumbColor: Colors.white,
                      inactiveTrackColor: Colors.grey.shade400,
                    ),
                    onTap: () {},
                  ),
                _buildDivider(),
                _buildSettingItem(
                  icon: Icons.devices_other,
                  title: 'Quản lý thiết bị đăng nhập',
                  onTap: () {
                    Get.toNamed(deviceManagerScreen);
                  },
                ),
                _buildDivider(),
                if (!kIsWeb)
                  _buildSettingItem(
                    icon: Icons.delete_outline,
                    title: 'Xóa tài khoản',
                    onTap: () {
                      BottomSheetHelper.showBottomSheetPopup(
                        child: const DeleteAccountDialog(),
                      );
                    },
                    textColor: Colors.red,
                    iconColor: Colors.red,
                    showTrailing: false,
                  ),
              ],
            ),
          ),
          const Expanded(child: SizedBox()),
        ],
      ),
    );
  }

  Widget _buildSettingItem({
    required IconData icon,
    required String title,
    required VoidCallback onTap,
    Widget? trailing,
    Color? textColor,
    Color? iconColor,
    bool showTrailing = true,
  }) {
    return ListTile(
      leading: Icon(icon, color: iconColor ?? Colors.black54),
      title: Text(
        title,
        style: TextStyle(
          fontSize: 16,
          color: textColor ?? Colors.black87,
          fontWeight: FontWeight.w500,
        ),
      ),
      trailing: trailing ?? (showTrailing ? const Icon(Icons.chevron_right, color: Colors.black26) : null),
      onTap: onTap,
      contentPadding: const EdgeInsets.symmetric(horizontal: 16),
    );
  }

  Widget _buildDivider() {
    return const Divider(height: 1, indent: 16, endIndent: 16);
  }
}