import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mypoint_flutter_app/screen/splash/splash_screen_viewmodel.dart';
import 'package:mypoint_flutter_app/widgets/alert/custom_alert_dialog.dart';
import '../../base/base_screen.dart';
import '../../base/basic_state.dart';
import 'models/check_update_response_model.dart';
import '../../resources/base_color.dart';
import '../../widgets/alert/data_alert_model.dart';

class SplashScreen extends BaseScreen {
  const SplashScreen({super.key});

  @override
  State<SplashScreen> createState() => _SplashScreenState();
}

class _SplashScreenState extends BaseState<SplashScreen> with BasicState {
  final SplashScreenViewModel _viewModel = Get.put(SplashScreenViewModel());

  @override
  void initState() {
    super.initState();
    _viewModel.checkUpdateResponse = (data) {
      WidgetsBinding.instance.addPostFrameCallback((_) {
        final updateData = (data?.updateRequest ?? []).firstOrNull;
        if (updateData == null) {
          _viewModel.makeDataFollowInitApp();
          return;
        }
        if (updateData.status == UpdateStatus.none) {
          _viewModel.directionWhenTokenInvalid();
        } else {
          _showSuggestUpdateAlert(updateData);
        }
      });
    };
    _viewModel.checkUpdateApp();
  }

  @override
  Widget createBody() {
    return Scaffold(
      backgroundColor: Colors.blue,
      body: Stack(
        children: [
          Container(
            width: double.infinity,
            height: double.infinity,
            decoration: BoxDecoration(
              image: DecorationImage(image: AssetImage("assets/images/splash_screen.png"), fit: BoxFit.cover),
            ),
          ),
          Center(child: CircularProgressIndicator()),
        ],
      ),
    );
  }

  void _showSuggestUpdateAlert(CheckUpdateResponseModel data) {
    final buttons = data.status == UpdateStatus.force
        ? [AlertButton(
              text: "Cập nhật ngay",
              onPressed: () {
                _viewModel.openLink();
              },
              bgColor: BaseColor.primary500,
              textColor: Colors.white,
            ),]
        : [AlertButton(
              text: "Cập nhật",
              onPressed: () {
                _viewModel.openLink();
              },
              bgColor: BaseColor.primary500,
              textColor: Colors.white,
            ),
            AlertButton(
              text: "Để sau",
              onPressed: () {
                Get.back();
                _viewModel.makeDataFollowInitApp();
              },
              bgColor: Colors.white,
              textColor: BaseColor.primary500,
            ),];
    final model = DataAlertModel(
      localHeaderImage: "assets/images/ic_pipi_03.png",
      title: data.updateTitle ?? "Cập nhật phiên bản mới",
      description: data.updateMessage ?? "Cập nhật phiên bản mới",
      buttons: buttons,
    );
    showAlert(data: model, showCloseButton: false, direction: ButtonsDirection.row);
  }
}
