import 'package:get/get_rx/src/rx_types/rx_types.dart';
import 'package:mypoint_flutter_app/networking/restful_api_client_all_request.dart';
import 'package:mypoint_flutter_app/screen/transaction/history/transaction_history_model.dart';
import '../../../networking/restful_api_viewmodel.dart';
import '../../../configs/constants.dart';

class TransactionHistoryDetailViewModel extends RestfulApiViewModel {
  String orderID;
  TransactionHistoryDetailViewModel({required this.orderID});

  var transactionData = Rxn<TransactionHistoryModel>();
  final RxBool isLoading = false.obs;
  void Function(String message)? onShowAlertError;

  @override
  void onInit() {
    super.onInit();
    _loadData();
  }

  Future<void> _loadData() async {
    showLoading();
    client.getTransactionHistoryDetail(orderID).then((value) {
      hideLoading();
      if (value.isSuccess) {
        transactionData.value = value.data;
      } else {
        onShowAlertError?.call(value.errorMessage ?? Constants.commonError);
      }
    });
  }
}
