enum MediaType {
  video,
  avatar,
  banner16_9,
  banner1_1,
  gallery,
}

extension MediaTypeExtension on MediaType {
  static MediaType? fromRawValue(String? rawValue) {
    switch (rawValue) {
      case 'MEDIA_TYPE_VIDEO':
        return MediaType.video;
      case 'MEDIA_TYPE_AVATAR':
        return MediaType.avatar;
      case 'MEDIA_TYPE_BANNER_16_9':
        return MediaType.banner16_9;
      case 'MEDIA_TYPE_BANNER_1_1':
        return MediaType.banner1_1;
      case 'MEDIA_TYPE_GALLERY':
        return MediaType.gallery;
      default:
        return null;
    }
  }

  String get rawValue {
    switch (this) {
      case MediaType.video:
        return 'MEDIA_TYPE_VIDEO';
      case MediaType.avatar:
        return 'MEDIA_TYPE_AVATAR';
      case MediaType.banner16_9:
        return 'MEDIA_TYPE_BANNER_16_9';
      case MediaType.banner1_1:
        return 'MEDIA_TYPE_BANNER_1_1';
      case MediaType.gallery:
        return 'MEDIA_TYPE_GALLERY';
    }
  }
}
