import 'package:json_annotation/json_annotation.dart';

import 'media_type.dart';

part 'product_media_item.g.dart';
@JsonSerializable()
class ProductMediaItem {
  final String? name;
  final String? url;
  @JsonKey(name: 'type')
  final String? rawType;

  ProductMediaItem({
    this.name,
    this.url,
    this.rawType,
  });

  MediaType? get type => MediaTypeExtension.fromRawValue(rawType);

  factory ProductMediaItem.fromJson(Map<String, dynamic> json) =>
      _$ProductMediaItemFromJson(json);

  Map<String, dynamic> toJson() => _$ProductMediaItemToJson(this);
}
