import 'package:flutter/material.dart';

class ButtonContainer extends StatelessWidget {
  final Color color;
  final double cornerRadius;
  final double? height;
  final double? width;
  final Widget child;
  final bool visible;

  const ButtonContainer({
    super.key,
    required this.child,
    this.height,
    this.width,
    this.color = Colors.white,
    this.cornerRadius = 8,
    this.visible = true,
  });

  @override
  Widget build(BuildContext context) {
    return Visibility(
      visible: visible,
      child: Container(
        decoration: BoxDecoration(borderRadius: BorderRadius.circular(cornerRadius), color: color),
        width: width,
        height: height,
        child: child,
      ),
    );
  }
}
