import 'package:json_annotation/json_annotation.dart';
import 'package:intl/intl.dart';

part 'preview_flash_sale_model.g.dart';
@JsonSerializable()
class PreviewFlashSale {
  final int? id;
  @JsonKey(name: 'countdown_second')
  final int? countdownSecond;
  @JsonKey(name: 'start_time')
  final String? startTime;
  @JsonKey(name: 'end_time')
  final String? endTime;
  @JsonKey(name: 'fs_quantity_total')
  final int? fsQuantityTotal;
  @JsonKey(name: 'fs_quantity_sold')
  final int? fsQuantitySold;
  @JsonKey(name: 'percent_tag')
  final int? percentTag;
  @JsonKey(name: 'reward_type')
  final String? rewardType;
  @JsonKey(name: 'reward_content')
  final String? rewardContent;
  @JsonKey(name: 'opening_content')
  final String? openingContent;
  final String? name;
  @JsonKey(name: 'reward_popup')
  final String? rewardPopup;
  final int? price;
  @JsonKey(name: 'is_flash_sale')
  final bool? isFlashSale;
  @JsonKey(name: 'is_flash_sale_price')
  final bool? isFlashSalePrice;
  @JsonKey(name: 'header_img')
  String? headerImg;
  @JsonKey(name: 'fs_quantity_per_person_total')
  final int? fsQuantityPerPersonTotal;
  @JsonKey(name: 'fs_quantity_per_person_bought')
  final int? fsQuantityPerPersonBought;

  PreviewFlashSale({
    this.id,
    this.countdownSecond,
    this.startTime,
    this.endTime,
    this.fsQuantityTotal,
    this.fsQuantitySold,
    this.percentTag,
    this.rewardType,
    this.rewardContent,
    this.openingContent,
    this.name,
    this.rewardPopup,
    this.price,
    this.isFlashSale,
    this.isFlashSalePrice,
    this.headerImg,
    this.fsQuantityPerPersonTotal,
    this.fsQuantityPerPersonBought,
  });

  /// Factory for json_serializable
  factory PreviewFlashSale.fromJson(Map<String, dynamic> json) => _$PreviewFlashSaleFromJson(json);

  Map<String, dynamic> toJson() => _$PreviewFlashSaleToJson(this);

  /// Computed properties (converted from Swift logic)
  double? get progress {
    if (fsQuantityTotal != null && fsQuantitySold != null && fsQuantityTotal! > 0) {
      return fsQuantitySold! / fsQuantityTotal!;
    }
    return null;
  }

  bool get isSoldOut => (fsQuantitySold ?? 0) == (fsQuantityTotal ?? 0);

  String get textQuantitySold => isSoldOut ? 'Đã bán hết' : 'Đã bán ${fsQuantitySold ?? 0}';

  bool get isHasReward => rewardContent != null && rewardContent!.isNotEmpty;

  String? get desTime {
    if (isGoingOn == null) return null;
    return isGoingOn! ? 'Kết thúc trong' : 'Bắt đầu sau';
  }

  int? get maximumQuantityPurchased {
    if (fsQuantityPerPersonTotal != null) {
      return (fsQuantityPerPersonTotal! - (fsQuantityPerPersonBought ?? 0)).clamp(0, fsQuantityPerPersonTotal!);
    }
    return null;
  }

  DateTime? get startDate => _parseDate(startTime)?.subtract(const Duration(seconds: 1));

  DateTime? get endDate => _parseDate(endTime)?.add(const Duration(seconds: 1));

  bool? get isGoingOn {
    final now = DateTime.now();
    if (startDate != null && endDate != null) {
      return now.isAfter(startDate!) && now.isBefore(endDate!);
    }
    return null;
  }

  Duration? get countdownLocal {
    if (isGoingOn == null) return null;
    final now = DateTime.now();
    if (isGoingOn!) {
      return endDate?.difference(now);
    } else {
      return startDate?.difference(now);
    }
  }

  bool get isHidenOpeningContent =>
      openingContent == null || openingContent!.isEmpty || isGoingOn == true || isFlashSalePrice == true;

  String? get imageReward {
    if (rewardType == 'point') {
      return 'assets/images/ic_point.png';
    }
    return 'assets/images/ic_gift_flash_sale.png';
  }

  /// Private helper
  DateTime? _parseDate(String? dateStr) {
    if (dateStr == null) return null;
    try {
      return DateFormat("yyyy-MM-dd HH:mm:ss").parse(dateStr);
    } catch (_) {
      return null;
    }
  }
}