import 'package:flutter/material.dart';
import 'package:mypoint_flutter_app/shared/widgets/image_loader.dart';
import '../../voucher/sub_widget/voucher_section_title.dart';
import '../../affiliate_brand_detail/models/brand_model.dart';
import '../models/main_section_config_model.dart';

class BrandGridWidget extends StatelessWidget {
  final List<BrandModel> brands;
  final MainSectionConfigModel? sectionConfig;
  final void Function(BrandModel)? onTap;

  const BrandGridWidget({super.key, required this.brands, this.sectionConfig, this.onTap});

  void _handleTapRightButton() {
    sectionConfig?.buttonViewAll?.directionalScreen?.begin();
  }

  @override
  Widget build(BuildContext context) {
    if (brands.isEmpty) {
      return const SizedBox.shrink();
    }
    return Column(
      children: [
        if ((sectionConfig?.name ?? "").isNotEmpty)
          HeaderSectionTitle(
            title: sectionConfig?.name ?? "",
            onViewAll: sectionConfig?.buttonViewAll?.directionalScreen != null ? _handleTapRightButton : null,
          ),
        GridView.builder(
          padding: EdgeInsets.all(0),
          shrinkWrap: true,
          physics: const NeverScrollableScrollPhysics(),
          itemCount: brands.length,
          gridDelegate: const SliverGridDelegateWithFixedCrossAxisCount(
            crossAxisCount: 3,
            childAspectRatio: 3 / 3,
            crossAxisSpacing: 0,
            mainAxisSpacing: 0,
          ),
          itemBuilder: (context, index) {
            final brand = brands[index];
            return _buildBrandItem(brand, index);
          },
        ),
      ],
    );
  }

  Widget _buildBrandItem(BrandModel brand, int index) {
    return LayoutBuilder(
      builder: (context, constraints) {
        final double imageWidth = constraints.maxWidth / 3;
        return GestureDetector(
          onTap: () {
              onTap?.call(brand);
          },
          child: Container(
            padding: const EdgeInsets.all(4),
            color: index % 2 != 0 ? Colors.red.shade50 : Colors.white,
            child: Column(
              mainAxisAlignment: MainAxisAlignment.center,
              children: [
                ClipRRect(
                  borderRadius: BorderRadius.circular(8),
                  child: SizedBox(
                    width: imageWidth,
                    height: imageWidth,
                    child: loadNetworkImage(
                      url: brand.logo ?? "",
                      fit: BoxFit.contain,
                      placeholderAsset: "assets/images/bg_default_11.png",
                    ),
                  ),
                ),
                const SizedBox(height: 4),
                Text(
                  textAlign: TextAlign.center,
                  brand.brandName ?? "",
                  maxLines: 2,
                  overflow: TextOverflow.ellipsis,
                  style: const TextStyle(fontWeight: FontWeight.w600, fontSize: 14),
                ),
                const SizedBox(height: 4),
                RichText(
                  textAlign: TextAlign.center,
                  text: TextSpan(
                    style: const TextStyle(fontSize: 12),
                    children: [
                      const TextSpan(text: "Hoàn đến: ", style: TextStyle(color: Colors.grey)),
                      TextSpan(
                        text: brand.pointAccumulationRate ?? '',
                        style: const TextStyle(color: Colors.orange, fontWeight: FontWeight.bold),
                      ),
                    ],
                  ),
                ),
              ],
            ),
          ),
        );
      },
    );
  }
}
