import 'package:json_annotation/json_annotation.dart';

part 'mobile_service_redeem_data.g.dart';
@JsonSerializable()
class MobileServiceRedeemData {
  @JsonKey(name: 'item_ids')
  final String? itemId;

  @JsonKey(name: 'customer_balance')
  final CustomerBalance? customerBalance;

  MobileServiceRedeemData({this.itemId, this.customerBalance});

  factory MobileServiceRedeemData.fromJson(Map<String, dynamic> json) =>
      _$MobileServiceRedeemDataFromJson(json);

  Map<String, dynamic> toJson() => _$MobileServiceRedeemDataToJson(this);
}

@JsonSerializable()
class CustomerBalance {
  @JsonKey(name: 'amount_active')
  final String? amountActive;

  CustomerBalance({this.amountActive});

  factory CustomerBalance.fromJson(Map<String, dynamic> json) =>
      _$CustomerBalanceFromJson(json);

  Map<String, dynamic> toJson() => _$CustomerBalanceToJson(this);
}