import 'package:json_annotation/json_annotation.dart';
import '../../../shared/navigation/directional_screen.dart';

part 'notification_item_model.g.dart';
@JsonSerializable()
class NotificationItemModel {
  @JsonKey(name: 'notification_id')
  final String? notificationId;
  final String? title;
  final String? body;
  final String? type;
  @JsonKey(name: 'click_action_type')
  final String? clickActionType;
  @JsonKey(name: 'click_action_param')
  final String? clickActionParam;
  @JsonKey(name: 'seen_at')
  String? seenAt;
  final String? status;
  @JsonKey(name: 'create_time')
  final String? createTime;
  @JsonKey(name: 'working_site')
  final WorkingSiteModel? workingSite;

  bool get hasSeen => (seenAt ?? "").isNotEmpty;

  DirectionalScreen? get directionalScreen {
    return DirectionalScreen.build(
      clickActionType: clickActionType,
      clickActionParam: clickActionParam,
    );
  }

  NotificationItemModel({
    this.notificationId,
    this.title,
    this.body,
    this.type,
    this.clickActionType,
    this.clickActionParam,
    this.seenAt,
    this.status,
    this.createTime,
    this.workingSite,
  });

  factory NotificationItemModel.fromJson(Map<String, dynamic> json) =>
      _$NotificationItemModelFromJson(json);
  Map<String, dynamic> toJson() => _$NotificationItemModelToJson(this);
}

class WorkingSiteModel {
  final String? avatar;

  WorkingSiteModel({
    this.avatar,
  });

  factory WorkingSiteModel.fromJson(Map<String, dynamic> json) {
    return WorkingSiteModel(
      avatar: json['avatar'] as String?,
    );
  }

  Map<String, dynamic> toJson() {
    return {
      'avatar': avatar,
    };
  }
}