import 'package:json_annotation/json_annotation.dart';

part 'campaign_detail_item_model.g.dart';
@JsonSerializable()
class CampaignDetailItemModel {
  @JsonKey(name: "content_caption")
  String? contentCaption;

  @JsonKey(name: "content_text")
  String? contentText;

  @JsonKey(name: "media_type")
  String? mediaType;

  List<CampaignItemPageModel>? pages;

  CampaignDetailItemModel({
    this.contentCaption,
    this.contentText,
    this.mediaType,
    this.pages,
  });

  factory CampaignDetailItemModel.fromJson(Map<String, dynamic> json) =>
      _$CampaignDetailItemModelFromJson(json);

  Map<String, dynamic> toJson() => _$CampaignDetailItemModelToJson(this);
}

class CampaignItemPageModel {
  final String? publishAtDate;
  final String? title;
  final String? pageId;
  final String? chapeau;
  final String? subTitle;
  final String? thumbnail;

  const CampaignItemPageModel({
    this.publishAtDate,
    this.title,
    this.pageId,
    this.chapeau,
    this.subTitle,
    this.thumbnail,
  });

  factory CampaignItemPageModel.fromJson(Map<String, dynamic> json) {
    return CampaignItemPageModel(
      publishAtDate: json['publish_at_date'] as String?,
      title: json['title'] as String?,
      pageId: json['page_id'] as String?,
      chapeau: json['chapeau'] as String?,
      subTitle: json['sub_title'] as String?,
      thumbnail: json['thumbnail'] as String?,
    );
  }

  Map<String, dynamic> toJson() {
    return {
      'publish_at_date': publishAtDate,
      'title': title,
      'page_id': pageId,
      'chapeau': chapeau,
      'sub_title': subTitle,
      'thumbnail': thumbnail,
    };
  }
}
