import 'package:json_annotation/json_annotation.dart';
import 'package:mypoint_flutter_app/features/register_campaign/model/verify_register_model.dart';
import 'form_input_description_model.dart';
import 'input_cell_model.dart';

part 'input_form_registration_model.g.dart';
@JsonSerializable()
class InputFormRegistrationModel {
  final String? title;
  @JsonKey(name: 'input_required')
  final List<InputCellModel>? inputRequired;
  @JsonKey(name: 'header_description')
  final FormInputDescriptionModel? headerDescription;
  @JsonKey(name: 'footer_description')
  final FormInputDescriptionModel? footerDescription;
  @JsonKey(name: 'click_action_type')
  final String? clickActionType;
  @JsonKey(name: 'click_action_param')
  final String? clickActionParam;
  final bool? checked;
  final VerifyFormRegisterModel? verify;

  InputFormRegistrationModel({
    this.title,
    this.inputRequired,
    this.headerDescription,
    this.footerDescription,
    this.clickActionType,
    this.clickActionParam,
    this.checked,
    this.verify,
  });

  factory InputFormRegistrationModel.fromJson(Map<String, dynamic> json) =>
      _$InputFormRegistrationModelFromJson(json);

  Map<String, dynamic> toJson() => _$InputFormRegistrationModelToJson(this);
}
