import 'package:flutter/material.dart';
import 'faqs_model.dart';

class FAQDetailScreen extends StatelessWidget {
  final PageItemModel faqItem;

  const FAQDetailScreen({super.key, required this.faqItem});

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: Text(faqItem.title ?? "", style: const TextStyle(fontWeight: FontWeight.bold)),
        backgroundColor: Colors.white,
        foregroundColor: Colors.black,
        elevation: 0,
      ),
      body: Padding(
        padding: const EdgeInsets.all(16.0),
        child: Text(
          faqItem.chapeau ?? "",
          style: const TextStyle(fontSize: 16, color: Colors.black87),
        ),
      ),
    );
  }
}
