import 'package:flutter/material.dart';
import '../../../shared/widgets/image_loader.dart';
import '../../voucher/sub_widget/voucher_section_title.dart';
import '../models/main_section_config_model.dart';
import '../models/main_service_model.dart';

class MainServiceGrid extends StatelessWidget {
  final List<MainServiceModel> services;
  final MainSectionConfigModel? sectionConfig;
  final void Function(MainServiceModel)? onTap;

  _handleTapRightButton() {
    sectionConfig?.buttonViewAll?.directionalScreen?.begin();
  }

  const MainServiceGrid({super.key, required this.services, this.onTap, this.sectionConfig});
  @override
  Widget build(BuildContext context) {
    return Column(
      children: [
        if ((sectionConfig?.name ?? "").isNotEmpty)
          HeaderSectionTitle(
            title: sectionConfig?.name ?? "",
            onViewAll: sectionConfig?.buttonViewAll?.directionalScreen != null ? _handleTapRightButton : null,
          ),
        SizedBox(
          height: 120,
          child: Padding(
            padding: const EdgeInsets.all(8.0),
            child: ListView.separated(
              scrollDirection: Axis.horizontal,
              padding: const EdgeInsets.symmetric(horizontal: 16),
              itemCount: services.length,
              separatorBuilder: (_, __) => const SizedBox(width: 16),
              itemBuilder: (context, index) => _buildItem(context, services[index]),
            ),
          ),
        ),
      ],
    );
  }

  Widget _buildItem(BuildContext context, MainServiceModel item) {
    return InkWell(
      onTap: () => onTap?.call(item),
      child: SizedBox(
        width: 64,
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.center,
          children: [
            Stack(
              alignment: Alignment.topRight,
              children: [
                Container(
                  width: 64,
                  height: 64,
                  padding: const EdgeInsets.all(10),
                  child:
                      item.serviceIcon != null && item.serviceIcon!.isNotEmpty
                          ? Image.asset(
                            item.serviceIcon!,
                            fit: BoxFit.contain,
                            errorBuilder:
                                (context, error, stackTrace) => loadNetworkImage(
                                  url: item.imageUrl,
                                  fit: BoxFit.contain,
                                  placeholderAsset: 'assets/images/ic_logo.png',
                                ),
                          )
                          : loadNetworkImage(
                            url: item.imageUrl,
                            fit: BoxFit.contain,
                            placeholderAsset: 'assets/images/ic_logo.png',
                          ),
                ),
                if (item.eventDescrible != null && item.eventDescrible!.isNotEmpty)
                  Positioned(
                    top: 2,
                    right: 2,
                    child: Container(
                      padding: const EdgeInsets.symmetric(horizontal: 6, vertical: 2),
                      decoration: BoxDecoration(
                        color: Color(_parseColor(item.eventColor ?? 'EB3C4B')),
                        borderRadius: BorderRadius.circular(12),
                      ),
                      child: Text(
                        item.eventDescrible!,
                        style: const TextStyle(color: Colors.white, fontSize: 10, fontWeight: FontWeight.bold),
                      ),
                    ),
                  ),
              ],
            ),
            Text(
              maxLines: 2,
              item.serviceName ?? '',
              textAlign: TextAlign.center,
              style: const TextStyle(fontSize: 13),
            ),
          ],
        ),
      ),
    );
  }

  int _parseColor(String hexColor) {
    hexColor = hexColor.replaceAll("#", "");
    if (hexColor.length == 6) {
      hexColor = "FF$hexColor";
    }
    return int.parse(hexColor, radix: 16);
  }
}
