import 'package:get/get_rx/src/rx_types/rx_types.dart';
import 'package:mypoint_flutter_app/core/network/restful_api_client_all_request.dart';
import '../../core/network/restful_api_viewmodel.dart';
import 'model/pipi_detail_model.dart';

class PipiDetailViewModel extends RestfulApiViewModel {
  final RxList<PipiSupportItemModel> items = <PipiSupportItemModel>[].obs;

  @override
  void onInit() {
    super.onInit();
    fetchPipiDetails();
  }

  Future<void> fetchPipiDetails() async {
    await callApi<PipiDetailResponseModel>(
      request: () => client.getPipiDetail(),
      onSuccess: (data, _) {
        items.assignAll(data.items ?? []);
      },
      onFailure: (msg, _, _) async {
        items.clear();
      },
    );
  }
}