import 'package:json_annotation/json_annotation.dart';
import 'package:mypoint_flutter_app/shared/navigation/directional_screen.dart';

part 'popup_manager_model.g.dart';
@JsonSerializable()
class PopupManagerModel {
  final String? id;
  @JsonKey(name: 'screen_to_show')
  final String? screenToShow;
  @JsonKey(name: 'click_action_type')
  final String? clickActionType;
  @JsonKey(name: 'click_action_param')
  final String? clickActionParam;
  @JsonKey(name: 'pos_action_id')
  final String? posActionID;
  @JsonKey(name: 'pos_action_code')
  final String? posActionCode;
  @JsonKey(name: 'time_to_show')
  String? timeToShow;
  @JsonKey(name: 'time_count_down')
  final String? timeCountDown;
  @JsonKey(name: 'hour_start_in_day')
  final String? hourStartInDay;
  @JsonKey(name: 'hour_stop_in_day')
  final String? hourStopInDay;
  @JsonKey(name: 'after_pos_id')
  final String? afterPosID;
  @JsonKey(name: 'after_pos_code')
  final String? afterPosCode;
  @JsonKey(name: 'after_pos_name')
  final String? afterPosName;
  @JsonKey(name: 'marketing_request_description')
  final String? marketingRequestDescription;
  @JsonKey(name: 'effective_from_date')
  final String? effectiveFromDate;
  @JsonKey(name: 'effective_to_date')
  final String? effectiveToDate;
  @JsonKey(name: 'schedule_run_type_code')
  final String? scheduleRunTypeCode;
  @JsonKey(name: 'schedule_run_type_name')
  final String? scheduleRunTypeName;
  @JsonKey(name: 'schedule_at_time')
  final String? scheduleAtTime;
  @JsonKey(name: 'popup_title_template')
  final String? popupTitleTemplate;
  @JsonKey(name: 'popup_body_template')
  final String? popupBodyTemplate;
  @JsonKey(name: 'image_id')
  final String? imageID;
  @JsonKey(name: 'image_url')
  final String? imageURL;
  @JsonKey(name: 'message_name')
  final String? messageName;
  @JsonKey(name: 'request_id')
  final String? requestId;

  PopupManagerModel({
    this.id,
    this.screenToShow,
    this.clickActionType,
    this.clickActionParam,
    this.posActionID,
    this.posActionCode,
    this.timeToShow,
    this.timeCountDown,
    this.hourStartInDay,
    this.hourStopInDay,
    this.afterPosID,
    this.afterPosCode,
    this.afterPosName,
    this.marketingRequestDescription,
    this.effectiveFromDate,
    this.effectiveToDate,
    this.scheduleRunTypeCode,
    this.scheduleRunTypeName,
    this.scheduleAtTime,
    this.popupTitleTemplate,
    this.popupBodyTemplate,
    this.imageID,
    this.imageURL,
    this.messageName,
    this.requestId,
  });

  DirectionalScreen? get directional {
    return DirectionalScreen.build(
      clickActionType: clickActionType,
      clickActionParam: clickActionParam,
    );
  }

  factory PopupManagerModel.fromJson(Map<String, dynamic> json) =>
      _$PopupManagerModelFromJson(json);

  Map<String, dynamic> toJson() => _$PopupManagerModelToJson(this);
}
