import 'package:json_annotation/json_annotation.dart';
import 'my_product_status_type.dart';

part 'product_customer_info_model.g.dart';
@JsonSerializable()
class ProductCustomerInfoModel {
  final int id;

  @JsonKey(name: 'status')
  final int? rawStatus;

  ProductCustomerInfoModel({
    required this.id,
    this.rawStatus,
  });

  MyProductStatusType get status =>
      MyProductStatusType.fromRaw(rawStatus ?? 0);

  factory ProductCustomerInfoModel.fromJson(Map<String, dynamic> json) =>
      _$ProductCustomerInfoModelFromJson(json);

  Map<String, dynamic> toJson() => _$ProductCustomerInfoModelToJson(this);
}
