/**
 * Use this library to read and write *.api.json files as defined by the
 * {@link https://api-extractor.com/ | API Extractor}  tool.  These files are used to generate a documentation
 * website for your TypeScript package.  The files store the API signatures and doc comments that were extracted
 * from your package.
 *
 * @packageDocumentation
 */
export { AedocDefinitions } from './aedoc/AedocDefinitions';
export { ReleaseTag } from './aedoc/ReleaseTag';
export { type IApiDeclaredItemOptions, ApiDeclaredItem } from './items/ApiDeclaredItem';
export { type IApiDocumentedItemOptions, ApiDocumentedItem } from './items/ApiDocumentedItem';
export { ApiItemKind, type IApiItemOptions, ApiItem, type IApiItemConstructor } from './items/ApiItem';
export { type IApiPropertyItemOptions, ApiPropertyItem } from './items/ApiPropertyItem';
export { type IApiParameterListMixinOptions, type IApiParameterOptions, ApiParameterListMixin } from './mixins/ApiParameterListMixin';
export { type IApiTypeParameterOptions, type IApiTypeParameterListMixinOptions, ApiTypeParameterListMixin } from './mixins/ApiTypeParameterListMixin';
export { type IApiAbstractMixinOptions, ApiAbstractMixin } from './mixins/ApiAbstractMixin';
export { type IApiItemContainerMixinOptions, ApiItemContainerMixin } from './mixins/ApiItemContainerMixin';
export { type IApiProtectedMixinOptions, ApiProtectedMixin } from './mixins/ApiProtectedMixin';
export { type IApiReleaseTagMixinOptions, ApiReleaseTagMixin } from './mixins/ApiReleaseTagMixin';
export { type IApiReturnTypeMixinOptions, ApiReturnTypeMixin } from './mixins/ApiReturnTypeMixin';
export { type IApiStaticMixinOptions, ApiStaticMixin } from './mixins/ApiStaticMixin';
export { type IApiNameMixinOptions, ApiNameMixin } from './mixins/ApiNameMixin';
export { type IApiOptionalMixinOptions, ApiOptionalMixin } from './mixins/ApiOptionalMixin';
export { type IApiReadonlyMixinOptions, ApiReadonlyMixin } from './mixins/ApiReadonlyMixin';
export { type IApiInitializerMixinOptions, ApiInitializerMixin } from './mixins/ApiInitializerMixin';
export { type IApiExportedMixinOptions, ApiExportedMixin } from './mixins/ApiExportedMixin';
export { type IFindApiItemsResult, type IFindApiItemsMessage, FindApiItemsMessageId } from './mixins/IFindApiItemsResult';
export { ExcerptTokenKind, type IExcerptTokenRange, type IExcerptToken, ExcerptToken, Excerpt } from './mixins/Excerpt';
export type { Constructor, PropertiesOf } from './mixins/Mixin';
export { type IApiCallSignatureOptions, ApiCallSignature } from './model/ApiCallSignature';
export { type IApiClassOptions, ApiClass } from './model/ApiClass';
export { type IApiConstructorOptions, ApiConstructor } from './model/ApiConstructor';
export { type IApiConstructSignatureOptions, ApiConstructSignature } from './model/ApiConstructSignature';
export { type IApiEntryPointOptions, ApiEntryPoint } from './model/ApiEntryPoint';
export { type IApiEnumOptions, ApiEnum } from './model/ApiEnum';
export { type IApiEnumMemberOptions, ApiEnumMember, EnumMemberOrder } from './model/ApiEnumMember';
export { type IApiFunctionOptions, ApiFunction } from './model/ApiFunction';
export { type IApiIndexSignatureOptions, ApiIndexSignature } from './model/ApiIndexSignature';
export { type IApiInterfaceOptions, ApiInterface } from './model/ApiInterface';
export { type IApiMethodOptions, ApiMethod } from './model/ApiMethod';
export { type IApiMethodSignatureOptions, ApiMethodSignature } from './model/ApiMethodSignature';
export { ApiModel } from './model/ApiModel';
export { type IApiNamespaceOptions, ApiNamespace } from './model/ApiNamespace';
export { type IApiPackageOptions, ApiPackage, type IApiPackageSaveOptions } from './model/ApiPackage';
export { type IParameterOptions, Parameter } from './model/Parameter';
export { type IApiPropertyOptions, ApiProperty } from './model/ApiProperty';
export { type IApiPropertySignatureOptions, ApiPropertySignature } from './model/ApiPropertySignature';
export { type IApiTypeAliasOptions, ApiTypeAlias } from './model/ApiTypeAlias';
export { type ITypeParameterOptions, TypeParameter } from './model/TypeParameter';
export { type IApiVariableOptions, ApiVariable } from './model/ApiVariable';
export { type IResolveDeclarationReferenceResult } from './model/ModelReferenceResolver';
export { HeritageType } from './model/HeritageType';
export { type ISourceLocationOptions, SourceLocation } from './model/SourceLocation';
//# sourceMappingURL=index.d.ts.map