import 'package:flutter/foundation.dart';

class UrlParams {
  static String? _token;
  static String? _userId;

  static String? get token => _token;
  static String? get userId => _userId;
  
  static void setToken(String? token) => _token = token;
  static void setUserId(String? userId) => _userId = userId;

  static Map<String, String?> get allParams => {
    'token': token,
    'user_id': userId,
  };
  
  static bool get hasToken => token != null && token!.isNotEmpty;
  static bool get hasUserId => userId != null && userId!.isNotEmpty;
  
  // Helper method để lấy token cho API calls
  static String? getTokenForApi() {
    return token;
  }
  
  // Helper method để lấy userId cho API calls
  static String? getUserIdForApi() {
    return userId;
  }
  
  @override
  String toString() => 'UrlParams: $allParams';
}
