import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:get/get_rx/src/rx_typedefs/rx_typedefs.dart';
import '../configs/constants.dart';
import '../preference/data_preference.dart';
import '../resources/base_color.dart';
import '../shared/router_gage.dart';
import '../widgets/alert/custom_alert_dialog.dart';
import '../widgets/alert/data_alert_model.dart';

class AppNavigator {
  static final GlobalKey<NavigatorState> key = GlobalKey<NavigatorState>();
  static bool _authDialogShown = false;
  static bool _networkDialogShown = false;
  static bool _errorDialogShown = false;

  static bool get isShowingDialog => _authDialogShown || _networkDialogShown || _errorDialogShown;
  static BuildContext? get _ctx => key.currentContext;

  static Future<void> showAuthAlertAndGoLogin(String message) async {
    if (_authDialogShown || _ctx == null) return;
    _authDialogShown = true;
    final dataAlert = DataAlertModel(
      title: "Thông Báo",
      description: message.isNotEmpty ? message : 'Phiên đăng nhập đã hết hạn. Vui lòng đăng nhập lại.',
      localHeaderImage: "assets/images/ic_pipi_03.png",
      buttons: [
        AlertButton(
          text: "Đã hiểu",
          onPressed: () {
            final phone = DataPreference.instance.phoneNumberUsedForLoginScreen;
            if (phone.isNotEmpty) {
              Get.offAllNamed(loginScreen, arguments: {'phone': phone});
            } else {
              DataPreference.instance.clearData();
              Get.offAllNamed(onboardingScreen);
            }
            _authDialogShown = false;
          },
          bgColor: BaseColor.primary500,
          textColor: Colors.white,
        ),
      ],
    );
    Get.dialog(CustomAlertDialog(alertData: dataAlert, showCloseButton: false), barrierDismissible: false);
  }

  static Future<void> showNoInternetAlert(String message, Callback retry, Callback close) async {
    if (_networkDialogShown || _ctx == null) return;
    _networkDialogShown = true;
    final dataAlert = DataAlertModel(
      title: "Thông Báo",
      description: message.isNotEmpty ? message : ErrorCodes.serverErrorMessage,
      localHeaderImage: "assets/images/ic_pipi_03.png",
      buttons: [
        AlertButton(
          text: "Thử lại",
          onPressed: () {
            _networkDialogShown = false;
            Get.back();
            retry();
          },
          bgColor: BaseColor.primary500,
          textColor: Colors.white,
        ),
        AlertButton(
          text: "Đóng",
          onPressed: () {
            _networkDialogShown = false;
            Get.back();
            close();
          },
          bgColor: BaseColor.second300,
          textColor: Colors.white,
        ),
      ],
    );
    Get.dialog(
      CustomAlertDialog(alertData: dataAlert, showCloseButton: false, direction: ButtonsDirection.row),
      barrierDismissible: false,
    );
  }

  static showAlertError({
    required String content,
    bool? barrierDismissible,
    String headerImage = "assets/images/ic_pipi_03.png",
    bool showCloseButton = false,
    VoidCallback? onConfirmed,
  }) {
    if (_errorDialogShown || _ctx == null) return;
    _errorDialogShown = true;
    Get.dialog(
      CustomAlertDialog(
        showCloseButton: showCloseButton,
        alertData: DataAlertModel(
          localHeaderImage: headerImage,
          title: "",
          description: content,
          buttons: [
            AlertButton(
              text: "Đã Hiểu",
              onPressed: () {
                _errorDialogShown = false;
                Get.back();
                if (onConfirmed != null) {
                  onConfirmed();
                }
              },
              bgColor: BaseColor.primary500,
              textColor: Colors.white,
            ),
          ],
        ),
      ),
      barrierDismissible: barrierDismissible ?? false,
    );
  }
}
