import 'package:dio/dio.dart';
import 'package:mypoint_flutter_app/preference/data_preference.dart';
import 'package:uuid/uuid.dart';

class RequestInterceptor extends Interceptor {
  @override
  Future<void> onRequest(RequestOptions options, RequestInterceptorHandler handler) async {
    String authKey = 'Authorization';
    String? token = DataPreference.instance.token;
    if (token!= null) {
      options.headers[authKey] = "Bearer $token";
    }
    options.headers.addAll({
      'Accept': 'application/json',
      'Content-Type': 'application/json',
      'Accept-Language': 'vi',
      'X-Request-Id': Uuid().v4(),
    });
    handler.next(options);
  }
}