import 'package:flutter/material.dart';

enum TextStyleIconAndText {
  header1,
  header2,
  header3,
  normal,
  underline,
  normalDisable,
  normalButton,
}

TextStyle header1 = TextStyle(
  fontSize: 22,
  fontWeight: FontWeight.bold,
  color: Colors.black,
);
TextStyle header2 = TextStyle(
  fontSize: 18,
  fontWeight: FontWeight.bold,
  color: Colors.black,
);
TextStyle header3 = TextStyle(
  fontSize: 16,
  fontWeight: FontWeight.bold,
  color: Colors.black,
);
const TextStyle textNormal = TextStyle(
  fontSize: 14,
  fontWeight: FontWeight.normal,
  color: Colors.black,
);
const TextStyle textMedium = TextStyle(
  fontSize: 14,
  fontWeight: FontWeight.w500,
  color: Colors.black,
);
const TextStyle textSemiBold = TextStyle(
  fontSize: 14,
  fontWeight: FontWeight.w600,
  color: Colors.black,
);
TextStyle textBold = TextStyle(
  fontSize: 14,
  fontWeight: FontWeight.bold,
  color: Colors.black,
);
TextStyle underline = TextStyle(
  fontSize: 14,
  fontWeight: FontWeight.normal,
  decoration: TextDecoration.underline,
  color: Colors.blue,
);
TextStyle normalDisable = TextStyle(
  fontSize: 14,
  fontWeight: FontWeight.bold,
  color: Colors.grey,
);
TextStyle normalButton = TextStyle(
  fontSize: 14,
  fontWeight: FontWeight.bold,
  color: Colors.white,
);

TextStyle getTextStyle(TextStyleIconAndText? textType) {
  switch (textType) {
    case TextStyleIconAndText.header1:
      return header1;
    case TextStyleIconAndText.header2:
      return header2;
    case TextStyleIconAndText.header3:
      return header3;
    case TextStyleIconAndText.normal:
      return textNormal;
    case TextStyleIconAndText.underline:
      return underline;
    case TextStyleIconAndText.normalDisable:
      return normalDisable;
    case TextStyleIconAndText.normalButton:
      return normalButton;
    default:
      return textNormal;
  }
}


class AppTextStyle {
  static const TextStyle title = TextStyle(
    fontSize: 18,
    fontWeight: FontWeight.bold,
    color: Colors.black87,
  );

  static const TextStyle content = TextStyle(
    fontSize: 14,
    color: Colors.black87,
  );

  static const TextStyle boldContent = TextStyle(
    fontSize: 14,
    fontWeight: FontWeight.bold,
    color: Colors.black87,
  );

  static const TextStyle link = TextStyle(
    fontSize: 14,
    color: Colors.blue,
    decoration: TextDecoration.underline,
  );

  static const TextStyle buttonPrimary = TextStyle(
    fontSize: 14,
    fontWeight: FontWeight.w500,
    color: Colors.white,
  );

  static const TextStyle buttonSecondary = TextStyle(
    fontSize: 14,
    fontWeight: FontWeight.w500,
    color: Colors.black,
  );
}
