import 'package:get/get_rx/src/rx_types/rx_types.dart';
import 'package:mypoint_flutter_app/networking/restful_api_client_all_request.dart';
import '../../networking/restful_api_viewmodel.dart';
import '../../configs/constants.dart';
import 'models/campaign_7day_info_model.dart';
import 'models/campaign_7day_mission_model.dart';
import 'models/campaign_7day_reward_model.dart';

class Campaign7DayViewModel extends RestfulApiViewModel {
  String campaignId;
  var liveTransactions = RxList<String>();
  var campaign7DayInfo = Rxn<Campaign7DayInfoModel>();

  void Function(String message)? onShowAlertError;
  void Function(Campaign7DayMissionModel mission)? submitPerformMissionResponse;
  void Function(List<Campaign7DayRewardModel> rewards)? getCampaignRewardsResponse;

  Campaign7DayViewModel({required this.campaignId});

  void getLiveTransactions() {
    client.getCampaignLiveTransactions(campaignId).then((value) {
      liveTransactions.value = value.data ?? [];
    });
  }

  void getCampaignRewards() {
    showLoading();
    client.getCampaignRewards(campaignId).then((value) {
      hideLoading();
      final data = value.data ?? [];
      if (!value.isSuccess) {
        onShowAlertError?.call(value.errorMessage ?? Constants.commonError);
        return;
      }
      if (data.isEmpty) {
        onShowAlertError?.call("Bạn chưa có phần thưởng nào. Vui lòng hoàn thành các nhiệm vụ để nhận thưởng!");
      } else {
        getCampaignRewardsResponse?.call(data);
      }
    });
  }

  void getCampaign7DayInfo() {
    client.getCampaignMissions(campaignId).then((value) {
      if (!value.isSuccess) {
        onShowAlertError?.call(value.errorMessage ?? Constants.commonError);
      }
      campaign7DayInfo.value = value.data;
    });
  }

  void submitPerformMission(Campaign7DayMissionModel mission) {
    if (!mission.isReady) return;
    showLoading();
    client.submitPerformMission(mission, campaignId).then((value) {
      hideLoading();
      if (value.isSuccess) {
        // getCampaign7DayInfo();
        if (mission.popup != null) {
          submitPerformMissionResponse?.call(mission);
        } else {
          mission.directionScreen?.begin();
        }
      } else {
        onShowAlertError?.call(value.errorMessage ?? Constants.commonError);
      }
    });
  }
}
