import 'package:get/get_rx/src/rx_types/rx_types.dart';
import 'package:mypoint_flutter_app/networking/restful_api_client_all_request.dart';
import 'package:mypoint_flutter_app/screen/game/models/game_bundle_item_model.dart';

import '../../networking/restful_api_viewmodel.dart';
import '../../configs/constants.dart';

class GameTabViewModel extends RestfulApiViewModel {
  final RxList<GameBundleItemModel> games = <GameBundleItemModel>[].obs;
  var turnsNumberText = "".obs;
  var isLoading = false.obs;
  void Function(String message)? onShowAlertError;
  void Function(GameBundleItemModel data)? gotoGameDetail;

  void getGames() {
    isLoading(true);
    client.getGames().then((value) {
      if (!value.isSuccess) {
        onShowAlertError?.call(value.errorMessage ?? Constants.commonError);
      } else {
        games.value = value.data?.games ?? [];
        turnsNumberText.value = value.data?.turnsNumberText ?? "";
      }
      isLoading(false);
    });
  }

  void getGameDetail(String gameId) {
    isLoading(true);
    client.getGameDetail(gameId).then((value) {
      if (!value.isSuccess) {
        onShowAlertError?.call(value.errorMessage ?? Constants.commonError);
      } else if (value.data != null) {
        gotoGameDetail?.call(value.data!);
      } else {
        onShowAlertError?.call(Constants.commonError);
      }
      isLoading(false);
    });
  }
}