import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mypoint_flutter_app/networking/restful_api_client_all_request.dart';
import 'package:mypoint_flutter_app/shared/router_gage.dart';
import '../../base/base_response_model.dart';
import '../../networking/restful_api_viewmodel.dart';
import '../../configs/constants.dart';
import '../../preference/data_preference.dart';
import '../../widgets/custom_toast_message.dart';
import '../splash/splash_screen_viewmodel.dart';
import 'otp_viewmodel.dart';

class DeleteAccountOtpRepository extends RestfulApiViewModel implements IOtpRepository {
  DeleteAccountOtpRepository(this.phoneNumber, this.otpTtl);

  @override
  int otpTtl;
  @override
  String phoneNumber;

  @override
  Future<void> sendOtp() async {}

  @override
  Future<BaseResponseModel<EmptyCodable>> verifyOtp(String otpCode) async {
    showLoading();
    return client.verifyDeleteAccount(otpCode).then((value) {
      hideLoading();
      if (value.isSuccess) {
        DataPreference.instance.clearBioToken(phoneNumber);
        DataPreference.instance.clearData();
        Get.offAllNamed(onboardingScreen);
        showToastMessage("Xóa tài khoản thành công");
      }
      return value;
    });
  }

  @override
  Future<int?> resendOtp() async {
    showLoading();
    client.requestOtpDeleteAccount().then((value) {
      hideLoading();
      if (value.isSuccess) {
        otpTtl = value.data?.resendAfterSecond ?? Constants.otpTtl;
      } else {
        final mgs = value.errorMessage ?? Constants.commonError;
        Get.snackbar("Thông báo", mgs);
      }
    });
  }
}
