import 'package:get/get.dart';
import 'package:flutter/material.dart';
import 'package:mypoint_flutter_app/configs/constants.dart';
import 'package:mypoint_flutter_app/networking/restful_api_client_all_request.dart';
import '../../base/base_response_model.dart';
import '../../networking/restful_api_viewmodel.dart';
import 'model/campaign_detail_model.dart';
import 'model/detail_page_rule_type.dart';

class CampaignDetailViewModel extends RestfulApiViewModel {
  var campaignDetail = BaseResponseModel<CampaignDetailResponseModel>().obs;
  var  isLoading = false.obs;
  var errorMessage = "".obs;

  void fetchData(DetailPageRuleType? type, String? pageId) {
    if ((pageId ?? "").isNotEmpty) {
      fetchWebsitePageGetDetail(pageId!);
      return;
    }
    if (type != null) {
      fetchWebsitePage(type!);
      return;
    }
    fetchFAQItems();
  }

  Future<void> fetchFAQItems() async {
    showLoading();
    isLoading(true);
    client.websiteFolderGetPageList({"folder_uri": "ABOUT"}).then((value) {
      hideLoading();
      isLoading(false);
      final pageId = (value.data?.items ?? []).first.pageId ?? "";
      if (pageId.isEmpty) {
        errorMessage.value = Constants.commonError;
      } else {
        fetchWebsitePageGetDetail(pageId);
      }
    });
  }

  void fetchWebsitePage(DetailPageRuleType type) {
    showLoading();
    isLoading(true);
    client.websitePage(type).then((value) {
      campaignDetail.value = value;
      if (!value.isSuccess) {
        errorMessage.value = value.errorMessage ?? Constants.commonError;
      }
      hideLoading();
      isLoading(false);
    });
  }

  void fetchWebsitePageGetDetail(String pageId) {
    showLoading();
    isLoading(true);
    client.websitePageGetDetail(pageId).then((value) {
      campaignDetail.value = value;
      if (!value.isSuccess) {
        errorMessage.value = value.errorMessage ?? Constants.commonError;
      }
      hideLoading();
      isLoading(false);
    });
  }
}
