import 'package:json_annotation/json_annotation.dart';
import 'package:mypoint_flutter_app/screen/register_campaign/model/registration_form_package_verify_model.dart';

import 'input_form_registration_model.dart';

part 'registration_form_package_model.g.dart';
@JsonSerializable()
class RegistrationFormPackageModel {
  @JsonKey(name: 'product_id')
  final String? productId;
  final VerifyModel? verify;
  @JsonKey(name: 'is_checked_registration')
  final bool? isCheckedRegistration;
  final String? id;
  final String? title;
  @JsonKey(name: 'form_confirm')
  final InputFormRegistrationModel? formConfirm;
  @JsonKey(name: 'click_action_param')
  final String? clickActionParam;
  @JsonKey(name: 'click_action_type')
  final String? clickActionType;
  @JsonKey(name: 'form_registration')
  final InputFormRegistrationModel? formRegistration;

  RegistrationFormPackageModel({
    this.productId,
    this.verify,
    this.isCheckedRegistration,
    this.id,
    this.title,
    this.formConfirm,
    this.clickActionParam,
    this.clickActionType,
    this.formRegistration,
  });

  factory RegistrationFormPackageModel.fromJson(Map<String, dynamic> json) =>
      _$RegistrationFormPackageModelFromJson(json);

  Map<String, dynamic> toJson() => _$RegistrationFormPackageModelToJson(this);
}
