// Web-specific implementations
// ignore: avoid_web_libraries_in_flutter
import 'dart:html' as html;

void webReplaceUrl(String path) {
  try {
    final origin = html.window.location.origin;
    final newUrl = '$origin$path';
    html.window.history.replaceState(null, html.document.title ?? '', newUrl);
  } catch (_) {}
}

void webClearStorage() {
  try {
    html.window.localStorage.clear();
    html.window.sessionStorage.clear();
    // Optionally clear caches if any
  } catch (_) {}
}


