import 'package:flutter/material.dart';
import 'package:get/get.dart';
import '../resources/base_color.dart';
import '../screen/support/support_screen.dart';

class SupportButton extends StatelessWidget {
  const SupportButton({super.key});

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: const EdgeInsets.only(right: 16),
      height: 36,
      decoration: BoxDecoration(
        border: Border.all(
          color: BaseColor.second500,
          width: 1,
        ),
        borderRadius: BorderRadius.circular(18),
        color: Colors.white,
      ),
      child: TextButton.icon(
        onPressed: () {
          Get.to(() => const SupportScreen());
        },
        icon: const Icon(
          Icons.headset_mic,
          size: 18,
          color: BaseColor.second600,
        ),
        label: const Text("Hỗ trợ"),
        style: TextButton.styleFrom(
          foregroundColor: BaseColor.second600,
          padding: const EdgeInsets.symmetric(horizontal: 8),
        ),
      ),
    );
  }
}
