# Đề xuất Cấu trúc Project (Refactored)

## Phân tích vấn đề hiện tại

### Vấn đề:
1. **Thiếu tổ chức theo layer**: Không rõ ràng về Presentation, Domain, Data layers
2. **Thư mục rời rạc**: `shared/`, `utils/`, `deferred/`, `directional/` không rõ mục đích
3. **Model chỉ có auth**: Thiếu models cho các features khác
4. **Screen quá lớn**: 375+ files trong một thư mục, khó quản lý
5. **Services và Networking tách rời**: Không có mối liên kết rõ ràng
6. **Thiếu domain layer**: Không có entities, use cases, repositories pattern

## Cấu trúc đề xuất (Clean Architecture + Feature-based)

```
flutter_app_mypoint/
├── lib/
│   ├── main.dart                    # Entry point
│   │
│   ├── core/                        # Core functionality (shared across features)
│   │   ├── config/                  # Configuration
│   │   │   ├── api_paths.dart
│   │   │   ├── constants.dart
│   │   │   ├── device_info.dart
│   │   │   └── env_loader.dart
│   │   │
│   │   ├── initialization/          # App initialization
│   │   │   ├── app_initializer.dart
│   │   │   ├── web_app_initializer.dart
│   │   │   └── deep_link_service.dart
│   │   │
│   │   ├── network/                 # Network layer
│   │   │   ├── api/                 # API clients
│   │   │   │   ├── affiliate_api.dart
│   │   │   │   ├── game_api.dart
│   │   │   │   ├── location_api.dart
│   │   │   │   ├── notification_api.dart
│   │   │   │   ├── product_api.dart
│   │   │   │   └── website_api.dart
│   │   │   ├── interceptor/         # HTTP interceptors
│   │   │   │   ├── auth_interceptor.dart
│   │   │   │   ├── exception_interceptor.dart
│   │   │   │   ├── logger_interceptor.dart
│   │   │   │   ├── network_error_gate.dart
│   │   │   │   └── request_interceptor.dart
│   │   │   ├── dio_http_service.dart
│   │   │   ├── error_mapper.dart
│   │   │   └── restful_api_client.dart
│   │   │
│   │   ├── storage/                 # Local storage
│   │   │   ├── data_preference.dart
│   │   │   ├── contact_storage_service.dart
│   │   │   └── point/
│   │   │       ├── point_manager.dart
│   │   │       └── header_home_model.dart
│   │   │
│   │   ├── services/                # Core services
│   │   │   ├── auth/
│   │   │   │   ├── login_service.dart
│   │   │   │   ├── logout_service.dart
│   │   │   │   └── token_refresh_service.dart
│   │   │   └── notification/
│   │   │       └── (notification services)
│   │   │
│   │   ├── platform/                # Platform-specific
│   │   │   ├── web/
│   │   │   │   ├── x_app_sdk_service.dart
│   │   │   │   ├── web_helper.dart
│   │   │   │   └── web_helper_web.dart
│   │   │   ├── permission/
│   │   │   │   └── biometric_manager.dart
│   │   │   └── firebase/
│   │   │       ├── firebase_options.dart
│   │   │       ├── push_notification.dart
│   │   │       └── push_setup.dart
│   │   │
│   │   ├── base/                    # Base classes
│   │   │   ├── base_screen.dart
│   │   │   ├── base_view_model.dart
│   │   │   ├── base_response_model.dart
│   │   │   └── basic_state.dart
│   │   │
│   │   ├── utils/                   # Utilities (merged shared + utils)
│   │   │   ├── validation_utils.dart
│   │   │   ├── direction_google_map.dart
│   │   │   ├── router_gage.dart
│   │   │   └── extensions/           # Extension methods
│   │   │       ├── collection_extension.dart
│   │   │       ├── color_extension.dart
│   │   │       ├── crypto.dart
│   │   │       ├── date_format.dart
│   │   │       ├── datetime_extensions.dart
│   │   │       ├── debouncer.dart
│   │   │       ├── num_extension.dart
│   │   │       └── string_extension.dart
│   │   │
│   │   ├── navigation/              # Navigation (merged deferred + directional)
│   │   │   ├── app_navigator.dart
│   │   │   ├── deferred_routes.dart
│   │   │   ├── directional_action_type.dart
│   │   │   └── directional_screen.dart
│   │   │
│   │   ├── theme/                   # Theme & Resources (renamed from resources)
│   │   │   ├── colors.dart          # base_color.dart
│   │   │   ├── text_styles.dart     # text_style.dart
│   │   │   ├── button_styles.dart   # button_style.dart
│   │   │   └── images.dart          # define_image.dart
│   │   │
│   │   └── widgets/                 # Core reusable widgets
│   │       ├── app_loading.dart
│   │       ├── alert/               # Alert widgets
│   │       ├── custom_app_bar.dart
│   │       ├── custom_empty_widget.dart
│   │       └── ... (other core widgets)
│   │
│   ├── features/                    # Feature modules (organized by domain)
│   │   │
│   │   ├── auth/                    # Authentication feature
│   │   │   ├── data/
│   │   │   │   ├── models/          # Data models
│   │   │   │   │   ├── login_token_response_model.dart
│   │   │   │   │   ├── profile_response_model.dart
│   │   │   │   │   └── ...
│   │   │   │   ├── repositories/    # Data repositories
│   │   │   │   │   └── auth_repository.dart
│   │   │   │   └── datasources/     # Data sources
│   │   │   │       └── auth_remote_datasource.dart
│   │   │   ├── domain/
│   │   │   │   ├── entities/         # Domain entities
│   │   │   │   │   └── user.dart
│   │   │   │   └── usecases/        # Use cases
│   │   │   │       ├── login_usecase.dart
│   │   │   │       └── logout_usecase.dart
│   │   │   └── presentation/
│   │   │       ├── screens/
│   │   │       │   ├── login/
│   │   │       │   ├── otp/
│   │   │       │   └── create_pass/
│   │   │       ├── viewmodels/
│   │   │       └── widgets/          # Feature-specific widgets
│   │   │
│   │   ├── home/                     # Home feature
│   │   │   ├── data/
│   │   │   │   ├── models/
│   │   │   │   └── repositories/
│   │   │   ├── domain/
│   │   │   │   ├── entities/
│   │   │   │   └── usecases/
│   │   │   └── presentation/
│   │   │       ├── screens/
│   │   │       │   └── (40 files from home/)
│   │   │       ├── viewmodels/
│   │   │       └── widgets/
│   │   │
│   │   ├── voucher/                  # Voucher feature
│   │   │   ├── data/
│   │   │   ├── domain/
│   │   │   └── presentation/
│   │   │       └── screens/          # (46 files from voucher/)
│   │   │
│   │   ├── transaction/             # Transaction feature
│   │   │   ├── data/
│   │   │   ├── domain/
│   │   │   └── presentation/
│   │   │       └── screens/          # (25 files from transaction/)
│   │   │
│   │   ├── campaign/                # Campaign features (merged)
│   │   │   ├── campaign7day/
│   │   │   ├── quiz_campaign/
│   │   │   ├── register_campaign/
│   │   │   └── invite_friend_campaign/
│   │   │
│   │   ├── payment/                 # Payment features (merged)
│   │   │   ├── electric_payment/
│   │   │   ├── mobile_card/
│   │   │   ├── topup/
│   │   │   └── traffic_service/
│   │   │
│   │   ├── point/                   # Point management
│   │   │   ├── history_point/
│   │   │   ├── history_point_cashback/
│   │   │   └── daily_checkin/
│   │   │
│   │   ├── profile/                 # Profile & Settings
│   │   │   ├── personal/
│   │   │   ├── setting/
│   │   │   ├── change_pass/
│   │   │   ├── delete_account/
│   │   │   └── biometric/
│   │   │
│   │   ├── notification/            # Notification feature
│   │   │   └── presentation/
│   │   │       └── screens/          # (12 files from notification/)
│   │   │
│   │   ├── membership/              # Membership feature
│   │   │   └── presentation/
│   │   │       └── screens/          # (10 files from membership/)
│   │   │
│   │   ├── affiliate/               # Affiliate feature
│   │   │   ├── affiliate/
│   │   │   └── affiliate_brand_detail/
│   │   │
│   │   ├── game/                    # Game features
│   │   │   ├── game/
│   │   │   └── vplay_game_center/
│   │   │
│   │   ├── support/                 # Support features
│   │   │   ├── support/
│   │   │   ├── faqs/
│   │   │   └── news/
│   │   │
│   │   └── common/                  # Common features
│   │       ├── splash/
│   │       ├── onboarding/
│   │       ├── webview/
│   │       ├── qr_code/
│   │       ├── popup_manager/
│   │       └── main_tab_screen/
│   │
│   └── shared/                      # Shared across features (optional)
│       └── widgets/                 # Shared widgets
│           ├── custom_navigation_bar.dart
│           ├── custom_point_text_tag.dart
│           └── ...
│
├── assets/                          # (unchanged)
├── web/                             # (unchanged)
├── android/                         # (unchanged)
├── ios/                             # (unchanged)
└── ... (other files unchanged)
```

## So sánh với cấu trúc hiện tại

### Cải thiện chính:

1. **Core layer rõ ràng**:
   - Gộp `configs/` vào `core/config/`
   - Gộp `shared/` và `utils/` vào `core/utils/`
   - Gộp `deferred/` và `directional/` vào `core/navigation/`
   - Đổi `resources/` thành `core/theme/` (rõ ràng hơn)

2. **Feature-based organization**:
   - Chia `screen/` thành các feature modules
   - Mỗi feature có cấu trúc: `data/`, `domain/`, `presentation/`
   - Dễ scale và maintain

3. **Separation of concerns**:
   - **Data layer**: Models, repositories, datasources
   - **Domain layer**: Entities, use cases
   - **Presentation layer**: Screens, viewmodels, widgets

4. **Grouping related features**:
   - Campaign features → `campaign/`
   - Payment features → `payment/`
   - Point features → `point/`
   - Profile features → `profile/`

## Migration Plan

### Phase 1: Reorganize Core (Low risk)
1. Gộp `configs/` → `core/config/`
2. Gộp `shared/` + `utils/` → `core/utils/`
3. Gộp `deferred/` + `directional/` → `core/navigation/`
4. Đổi `resources/` → `core/theme/`

### Phase 2: Reorganize Network & Services (Medium risk)
1. Di chuyển `networking/` → `core/network/`
2. Di chuyển `services/` → `core/services/`
3. Di chuyển `preference/` → `core/storage/`

### Phase 3: Feature-based organization (High risk, cần test kỹ)
1. Tạo structure cho từng feature
2. Di chuyển screens theo feature
3. Tạo data/domain/presentation layers

## Lợi ích

1. **Scalability**: Dễ thêm features mới
2. **Maintainability**: Code được tổ chức rõ ràng
3. **Testability**: Dễ test từng layer riêng biệt
4. **Team collaboration**: Nhiều người có thể làm việc trên các features khác nhau
5. **Code reuse**: Core layer có thể reuse cho nhiều features

## Lưu ý

- Migration cần làm từng bước, test kỹ sau mỗi bước
- Có thể giữ cấu trúc cũ song song trong thời gian transition
- Update imports và dependencies sau mỗi bước di chuyển

