import '../../base/base_response_model.dart';
import '../../configs/api_paths.dart';
import '../../configs/callbacks.dart';
import '../restful_api_client.dart';
import '../../screen/game/models/game_bundle_item_model.dart';
import '../../screen/game/models/game_bundle_response.dart';

class GameApi {
  GameApi(this.client);

  final RestfulAPIClient client;

  Future<BaseResponseModel<GameBundleResponse>> getGames() {
    return client.requestNormal(
      APIPaths.getGames,
      Method.GET,
      const {},
      (data) => GameBundleResponse.fromJson(data as Json),
    );
  }

  Future<BaseResponseModel<GameBundleItemModel>> getGameDetail(String id) {
    final path = APIPaths.getGameDetail.replaceAll('%@', id);
    return client.requestNormal(
      path,
      Method.POST,
      const {},
      (data) => GameBundleItemModel.fromJson(data as Json),
    );
  }

  Future<BaseResponseModel<GameBundleItemModel>> submitGameCard(
    String gameId,
    String itemId,
  ) {
    final path = APIPaths.submitGameCard
        .replaceFirst('%@', gameId)
        .replaceFirst('%@', itemId);
    return client.requestNormal(
      path,
      Method.POST,
      const {},
      (data) => GameBundleItemModel.fromJson(data as Json),
    );
  }
}
