import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mypoint_flutter_app/widgets/custom_empty_widget.dart';
import 'package:mypoint_flutter_app/widgets/image_loader.dart';
import '../../widgets/custom_navigation_bar.dart';
import '../home/models/achievement_model.dart';
import 'achievement_viewmodel.dart';

class AchievementListScreen extends StatefulWidget {
  const AchievementListScreen({super.key});

  @override
  State<AchievementListScreen> createState() => _AchievementListScreenState();
}

class _AchievementListScreenState extends State<AchievementListScreen> {
  late final AchievementViewModel _viewModel;
  String _title = "Thử thách trúng quà";
  bool isPointHunting = false;

  @override
  void initState() {
    super.initState();
    final args = Get.arguments;
    if (args is bool) {
      isPointHunting = args;
    }
    if (isPointHunting == true) {
      _title = "Săn điểm";
    }
    _viewModel = Get.put(AchievementViewModel(isPointHunting: isPointHunting));
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: CustomNavigationBar(title: _title),
      body: Obx(() {
        if (isPointHunting) {
          return _buildPointHuntingContent();
        } else {
          return _buildAchievementContent();
        }
      }),
    );
  }

  Widget _buildAchievementContent() {
    final items = _viewModel.achievements;
    if (items.isEmpty) {
      return EmptyWidget();
    }
    return Padding(
      padding: const EdgeInsets.all(16.0),
      child: GridView.builder(
        itemCount: items.length,
        gridDelegate: const SliverGridDelegateWithFixedCrossAxisCount(
          crossAxisCount: 2,
          crossAxisSpacing: 12,
          mainAxisSpacing: 12,
          childAspectRatio: 4 / 3,
        ),
        itemBuilder: (context, index) {
          final item = items[index];
          return GestureDetector(
            onTap: () {
              item.directionScreen?.begin();
            },
            child: ClipRRect(
              borderRadius: BorderRadius.circular(12),
              child: loadNetworkImage(
                url: item.urlBackground ?? '',
                placeholderAsset: 'assets/images/bg_default_34.png',
              ),
            ),
          );
        },
      ),
    );
  }

  Widget _buildPointHuntingContent() {
    final items = _viewModel.achievements;
    return items.isEmpty
        ? EmptyWidget()
        : RefreshIndicator(
          onRefresh: () => _viewModel.fetchAchievements(),
          child: CustomScrollView(
            physics: const AlwaysScrollableScrollPhysics(),
            slivers: [
              SliverToBoxAdapter(
                child: Padding(
                  padding: const EdgeInsets.symmetric(horizontal: 32, vertical: 12),
                  child: Image.asset("assets/images/bg_header_hunt_points.png"),
                ),
              ),
              SliverList(
                delegate: SliverChildBuilderDelegate((context, index) {
                  final item = items[index];
                  return _buildPointHuntingItem(item);
                }, childCount: items.length),
              ),
            ],
          ),
        );
  }

  Widget _buildPointHuntingItem(AchievementModel item) {
    return GestureDetector(
      onTap: () {
        item.directionScreen?.begin();
      },
      child: Padding(
        padding: const EdgeInsets.only(left: 16, right: 16, top: 8, bottom: 8),
        child: ClipRRect(
          borderRadius: BorderRadius.circular(12),
          child: loadNetworkImage(url: item.urlBackground ?? '', placeholderAsset: 'assets/images/bg_default_169.png'),
        ),
      ),
    );
  }
}
