import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:local_auth/local_auth.dart';
import '../../base/base_screen.dart';
import '../../base/basic_state.dart';
import '../../resources/base_color.dart';
import '../../widgets/alert/data_alert_model.dart';
import '../main_tab_screen/main_tab_screen.dart';
import 'biometric_viewmodel.dart';


class BiometricAuthScreen extends BaseScreen {
  const BiometricAuthScreen({super.key});

  @override
  State<BiometricAuthScreen> createState() => _BiometricAuthScreenState();
}

class _BiometricAuthScreenState extends BaseState<BiometricAuthScreen> with BasicState {
  final controller = Get.put(BiometricViewModel());

  @override
  initState() {
    super.initState();
    controller.onShowAlertError = (message) {
      showAlertError(
          content: message,
          barrierDismissible: true,
          onConfirmed: () {
            Get.offAll(MainTabScreen());
          });
    };

    controller.registerBiometricResponse = (result) {
      var title = result
          ? "Kích hoạt sinh trắc học thành công!"
          : "Kích hoạt sinh trắc học thất bại!";
      var type = controller.biometricType.value == BiometricType.face ? "Face ID" : "Touch ID";
      var message = result
          ? "Từ bây giờ bạn có thể sử dụng $type để đăng nhập thay vì nhập mật khẩu."
          : "Đã có lỗi xảy ra khi xác thực thông tin sinh trắc học. Vui lòng thử lại sau.";
      DataAlertModel alertData = DataAlertModel(
        localHeaderImage: result? "assets/images/ic_pipi_05.png" : "assets/images/ic_pipi_03.png",
        title: title,
        description: message,
        buttons: [
          AlertButton(
            text: "Đã hiểu",
            onPressed: () => Get.offAll(MainTabScreen()),
            bgColor: BaseColor.primary500,
            textColor: Colors.white,
          ),
        ],
      );
      showAlert(data: alertData);
    };
  }

  @override
  Widget createBody() {
    return Scaffold(
      appBar: AppBar(
        automaticallyImplyLeading: false,
        leading: null,
        title: Obx(() {
          String title = controller.biometricType.value == BiometricType.face ? "Face ID" : "Touch ID";
          return Text(title);
        }),
        backgroundColor: Colors.white,
        foregroundColor: Colors.black,
        elevation: 0,
      ),
      body: Center(
        child: Padding(
          padding: const EdgeInsets.symmetric(horizontal: 20),
          child: Column(
            mainAxisAlignment: MainAxisAlignment.center,
            children: [
              const Spacer(),
              Obx(() {
                final icon = controller.biometricType.value == BiometricType.face
                    ? Icons.face
                    : Icons.fingerprint;
                return Icon(icon, size: 80, color: Colors.black54);
              }),
              const SizedBox(height: 20),
              Obx(() {
                final title = controller.biometricType.value == BiometricType.face
                    ? "Kích hoạt xác thực Face ID"
                    : "Kích hoạt xác thực vân tay";
                return Text(title,
                    style: const TextStyle(fontSize: 24, fontWeight: FontWeight.bold));
              }),
              const SizedBox(height: 10),
              Obx(() {
                final description = controller.biometricType.value == BiometricType.face
                    ? "Kích hoạt xác thực Face ID để đăng nhập nhanh không cần mật khẩu.\nBạn có muốn thực hiện không?"
                    : "Kích hoạt xác thực vân tay để đăng nhập nhanh không cần mật khẩu.\nBạn có muốn thực hiện không?";
                return Text(description,
                    textAlign: TextAlign.center,
                    style: const TextStyle(fontSize: 16, color: Colors.black54));
              }),
              // const SizedBox(height: 80),
              const Spacer(),
              SizedBox(
                width: double.infinity,
                child: ElevatedButton(
                  onPressed: () => controller.registerBiometric(),
                  style: ElevatedButton.styleFrom(
                    padding: const EdgeInsets.symmetric(vertical: 15),
                    backgroundColor: Colors.redAccent,
                    shape: RoundedRectangleBorder(
                      borderRadius: BorderRadius.circular(10),
                    ),
                  ),
                  child: const Text("Kích hoạt",
                      style: TextStyle(color: Colors.white, fontSize: 18)),
                ),
              ),
              const SizedBox(height: 10),
              TextButton(
                onPressed: () => Get.to(MainTabScreen()),
                child: const Text("Để sau", style: TextStyle(fontSize: 16, color: Colors.black54)),
              ),
              const SizedBox(height: 80),
            ],
          ),
        ),
      ),
    );
  }
}
