import 'dart:ui';
import 'cash_history_model.dart';
import 'package:mypoint_flutter_app/screen/history_point/models/transaction_history_model.dart';

class ListHistoryResponseModel {
  final List<TransactionHistoryModel>? historyTransaction;
  final List<CashHistoryModel>? historyCash;

  ListHistoryResponseModel({this.historyTransaction, this.historyCash});

  factory ListHistoryResponseModel.fromJson(Map<String, dynamic> json) {
    return ListHistoryResponseModel(
      historyTransaction: (json['history'] as List<dynamic>?)
          ?.map((e) => TransactionHistoryModel.fromJson(e as Map<String, dynamic>))
          .toList(),
      historyCash: (json['history_cash'] as List<dynamic>?)
          ?.map((e) => CashHistoryModel.fromJson(e as Map<String, dynamic>))
          .toList(),
    );
  }

  Map<String, dynamic> toJson() => {
        'history': historyTransaction?.map((e) => e.toJson()).toList(),
        'history_cash': historyCash?.map((e) => e.toJson()).toList(),
      };
}

enum HistoryPointStatus { processing, success, rejected }

extension CashStatusX on HistoryPointStatus {
  String get title {
    switch (this) {
      case HistoryPointStatus.processing:
        return 'Đang chờ';
      case HistoryPointStatus.success:
        return 'Thành công';
      case HistoryPointStatus.rejected:
        return 'Đã hủy';
    }
  }

  Color get color {
    switch (this) {
      case HistoryPointStatus.processing:
        return _hexColor('#FF7527');
      case HistoryPointStatus.success:
        return _hexColor('#04AF5D');
      case HistoryPointStatus.rejected:
        return _hexColor('#D42230');
    }
  }

  Color _hexColor(String hex) {
    var c = hex.replaceAll('#', '').trim();
    if (c.length == 6) c = 'FF$c';
    final v = int.tryParse(c, radix: 16) ?? 0xFF000000;
    return Color(v);
  }
}

