import 'package:flutter/material.dart';
import 'package:get/get.dart';
import '../../../shared/router_gage.dart';
import '../../../widgets/custom_empty_widget.dart';
import '../../../widgets/custom_navigation_bar.dart';
import 'news_item_widget.dart';
import 'news_list_viewmodel.dart';

class NewsListScreen extends StatefulWidget {
  const NewsListScreen({super.key});

  @override
  _NewsListScreenState createState() => _NewsListScreenState();
}

class _NewsListScreenState extends State<NewsListScreen> {
  late final NewsListViewModel _viewModel = Get.put(NewsListViewModel());

  @override
  void initState() {
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: Colors.grey[50],
      appBar: CustomNavigationBar(title: "MyPoint có gì hot?"),
      body: Column(
        children: [
          Expanded(
            child: Obx(() {
              if (_viewModel.newsList.value.isEmpty) {
                return const Center(child: EmptyWidget());
              }
              return RefreshIndicator(
                onRefresh: () => _viewModel.getNewsList(isRefresh: true),
                child: ListView.builder(
                  physics: const AlwaysScrollableScrollPhysics(),
                  itemCount: _viewModel.newsList.length,
                  itemBuilder: (context, index) {
                    if (index >= _viewModel.newsList.length) {
                      _viewModel.getNewsList(isRefresh: false);
                      return const Center(
                        child: Padding(padding: EdgeInsets.all(16), child: CircularProgressIndicator()),
                      );
                    }
                    final news = _viewModel.newsList.value[index];
                    return GestureDetector(
                      onTap: () {
                        Get.toNamed(campaignDetailScreen, arguments: {"id": news.pageId ?? ""});
                      },
                      child: PageItemWidget(item: news),
                    );
                  },
                ),
              );
            }),
          ),
        ],
      ),
    );
  }
}
