import 'package:get/get_rx/src/rx_types/rx_types.dart';
import 'package:mypoint_flutter_app/configs/constants.dart';
import 'package:mypoint_flutter_app/networking/restful_api_client_all_request.dart';
import 'package:mypoint_flutter_app/screen/quiz_campaign/quiz_campaign_model.dart';

import '../../networking/restful_api_viewmodel.dart';
import '../../widgets/alert/popup_data_model.dart';

class QuizCampaignViewModel extends RestfulApiViewModel {
  var surveyData = Rxn<SurveyCampaignInfoModel>();
  String quizId;
  void Function(String message, {bool shouldQuitScreen})? onShowAlertError;
  void Function(PopupDataModel data)? quizCampaignSubmitResponse;

  QuizCampaignViewModel({required this.quizId});

  Future<void> getQuizCampaignDetail() async {
    showLoading();
    try {
      final response = await client.getCampaignQuizSurvey(quizId);
      hideLoading();
      surveyData.value = response.data;
      if (surveyData.value == null) {
        onShowAlertError?.call(Constants.commonError, shouldQuitScreen: true);
      }
    } catch (error) {
      hideLoading();
      onShowAlertError?.call(Constants.commonError);
    }
  }

  Future<void> quizCampaignSubmit() async {
    showLoading();
    final body = surveyData.value?.submitParam ?? {};
    try {
      final response = await client.quizSubmitCampaign(quizId, body);
      hideLoading();
      final popup = response.data?.popup;
      if (popup != null) {
        quizCampaignSubmitResponse?.call(popup);
      } else {
        onShowAlertError?.call(response.errorMessage ?? Constants.commonError);
      }
    } catch (error) {
      hideLoading();
      onShowAlertError?.call(Constants.commonError);
    }
  }
}