import 'package:json_annotation/json_annotation.dart';

part 'worker_site_model.g.dart';

@JsonSerializable()
class WorkerSiteModel {
  final String? id;
  final String? fullname;
  final String? nickname;
  @JsonKey(name: "avatar_2")
  final String? avatar2;
  @JsonKey(name: "customer_id")
  final String? customerId;
  @JsonKey(name: "phone_number")
  final String? phoneNumber;
  final String? birthday;
  final String? sex;
  @JsonKey(name: "address_full")
  final String? addressFull;
  @JsonKey(name: "location_district_code")
  final String? locationDistrictCode;
  @JsonKey(name: "location_district_name")
  final String? locationDistrictName;
  @JsonKey(name: "location_province_code")
  final String? locationProvinceCode;
  @JsonKey(name: "location_province_name")
  final String? locationProvinceName;
  @JsonKey(name: "identification_number")
  final String? identificationNumber;
  final String? email;
  @JsonKey(name: "sex_label")
  final String? sexLabel;

  WorkerSiteModel({
    this.id,
    this.fullname,
    this.nickname,
    this.avatar2,
    this.customerId,
    this.phoneNumber,
    this.birthday,
    this.sex,
    this.addressFull,
    this.locationDistrictCode,
    this.locationDistrictName,
    this.locationProvinceCode,
    this.locationProvinceName,
    this.identificationNumber,
    this.email,
    this.sexLabel,
  });

  /// 🎯 Convert JSON → Object
  factory WorkerSiteModel.fromJson(Map<String, dynamic> json) => _$WorkerSiteModelFromJson(json);

  /// 🎯 Convert Object → JSON
  Map<String, dynamic> toJson() => _$WorkerSiteModelToJson(this);

  bool get isRequireUpdateProfile {
    return false;
    // return (email == null || email!.isEmpty) || (birthday == null || birthday!.isEmpty);
  }

  String get usernameDisplay {
    if (nickname != null && nickname!.isNotEmpty) {
      return nickname!;
    } else if (fullname != null && fullname!.isNotEmpty) {
      return fullname!;
    } else {
      return "Quý Khách";
    }
  }
}