import 'package:json_annotation/json_annotation.dart';
import '../../../directional/directional_screen.dart';
import 'campaign_7day_config_model.dart';

part 'campaign_7day_reward_model.g.dart';
@JsonSerializable()
class Campaign7DayRewardModel {
  @JsonKey(name: 'type')
  final String? type;
  final String? value;
  @JsonKey(name: 'text_display')
  final String? textDisplay;
  @JsonKey(name: 'created_at')
  final String? createdAt;
  @JsonKey(name: 'click_action_type')
  final String? clickActionType;
  @JsonKey(name: 'click_action_params')
  final String? clickActionParams;
  @JsonKey(name: 'button_text')
  final String? buttonText;

  Campaign7DayRewardModel({
    this.type,
    this.value,
    this.textDisplay,
    this.createdAt,
    this.clickActionType,
    this.clickActionParams,
    this.buttonText,
  });

  TypeReward get typeReward =>
      TypeReward.values.firstWhere((e) => e.name == type?.toLowerCase(), orElse: () => TypeReward.point);

  String get imageAsset =>
      (typeReward == TypeReward.point) ? 'assets/images/ic_point.png' : 'assets/images/ic_campaign_voucher_gift.png';

  DirectionalScreen? get direction =>
      (clickActionType != null && clickActionParams != null)
          ? DirectionalScreen.build(clickActionType: clickActionType, clickActionParam: clickActionParams)
          : null;

  factory Campaign7DayRewardModel.fromJson(Map<String, dynamic> json) =>
      _$Campaign7DayRewardModelFromJson(json);
  Map<String, dynamic> toJson() => _$Campaign7DayRewardModelToJson(this);
}



