import 'package:get/get.dart';
import 'package:mypoint_flutter_app/networking/restful_api_client_all_request.dart';
import '../../networking/restful_api_viewmodel.dart';
import 'electric_payment_bill_screen.dart';
import 'models/customer_contract_object_model.dart';

class ElectricPaymentViewModel extends RestfulApiViewModel {
  void Function(String message)? onShowAlertError;
  final RxList<CustomerContractModel> billContracts = <CustomerContractModel>[].obs;

  void customerContractRequestSearch(String maKH) {
    callApi<CustomerContractModel>(
      request: () => client.customerContractRequestSearch(maKH),
      onSuccess: (data, _) {
        if ((data.amount ?? 0) == 0) {
          onShowAlertError?.call("Bạn đã thanh toán hết hóa đơn.");
        } else {
          Get.to(ElectricPaymentBillScreen(bill: data));
        }
      },
      onFailure: (msg, _, _) async {
        onShowAlertError?.call(msg);
      },
      defaultError: "Không tìm thấy thông tin mã khách hàng, vui lòng kiểm tra và thử lại."
    );
  }

  void customerContractSearchHistoryGetList() {
    callApi<List<CustomerContractModel>>(
      request: () => client.customerContractSearchHistoryGetList(),
      onSuccess: (data, _) {
        billContracts.assignAll(data);
      },
      onFailure: (msg, _, _) async {
        billContracts.clear();
        onShowAlertError?.call(msg);
      },
    );
  }

  void customerContractDelete(String code) {
    callApi<bool>(
      request: () => client.customerContractDelete(code),
      onSuccess: (_, _) {
        customerContractSearchHistoryGetList();
      },
      onFailure: (msg, _, _) async {
        onShowAlertError?.call(msg);
      },
    );
  }
}
