import 'package:json_annotation/json_annotation.dart';
import '../traffic_service/traffic_service_model.dart';

part 'health_book_model.g.dart';
@JsonSerializable(explicitToJson: true)
class HealthBookCardItemModel {
  @JsonKey(name: 'item_id')
  final int? itemId;
  @JsonKey(name: 'card_name')
  final String? cardName;
  @JsonKey(name: 'full_name')
  final String? fullName;
  @JsonKey(name: 'card_code')
  final String? cardCode;
  @JsonKey(name: 'expire_date')
  final String? expireDate;
  @JsonKey(name: 'phone_number')
  final String? phoneNumber;
  @JsonKey(name: 'updated_at')
  final String? updatedAt;
  @JsonKey(name: 'count_checkup_unused')
  final int? countCheckupUnused;
  @JsonKey(name: 'bottom_button')
  final ButtonConfigModel? bottomButton;
  final List<ProductMediaItem>? media;
  @JsonKey(name: 'buy_more_note')
  final ButtonConfigModel? buyMoreNote;
  final ActiveTextConfig? active;

  const HealthBookCardItemModel({
    this.itemId,
    this.cardName,
    this.fullName,
    this.cardCode,
    this.expireDate,
    this.phoneNumber,
    this.updatedAt,
    this.countCheckupUnused,
    this.bottomButton,
    this.media,
    this.buyMoreNote,
    this.active,
  });

  factory HealthBookCardItemModel.fromJson(Map<String, dynamic> json)
  => _$HealthBookCardItemModelFromJson(json);
  Map<String, dynamic> toJson() => _$HealthBookCardItemModelToJson(this);
}

class HealthBookResponseModel {
  final int? total;
  final List<HealthBookCardItemModel>? products;

  HealthBookResponseModel({
    this.total,
    this.products,
  });

  factory HealthBookResponseModel.fromJson(Map<String, dynamic> json) {
    return HealthBookResponseModel(
      total: json['total'],
      products: (json['products'] as List<dynamic>?)
          ?.map((e) => HealthBookCardItemModel.fromJson(e))
          .toList(),
    );
  }

  Map<String, dynamic> toJson() => {
    'total': total,
    'products': products?.map((e) => e.toJson()).toList(),
  };
}
