import 'package:json_annotation/json_annotation.dart';

part 'product_brand_model.g.dart';

@JsonSerializable()
class ProductBrandModel {
  final int? id;
  final String? logo;
  final String? name;
  final String? email;
  final String? phone;
  final String? website;
  final String? code;

  ProductBrandModel({
    this.id,
    this.logo,
    this.name,
    this.email,
    this.phone,
    this.website,
    this.code,
  });

  factory ProductBrandModel.fromJson(Map<String, dynamic> json) => _$ProductBrandModelFromJson(json);
  Map<String, dynamic> toJson() => _$ProductBrandModelToJson(this);
}

class PrefixMobileCarrier {
  static const String mobiFoneCode = "MOBIFONE";
  static const String viettelCode = "VIETTEL";
  static const String vinaphoneCode = "VINAPHONE";
  static const String vietNamMobile = "VNM";

  static List<String> viettelPrefixNumbers() => [
    "086", "096", "097", "098",
    "032", "033", "034", "035", "036", "037", "038", "039",
  ];

  static List<String> vinaPhonePrefixNumbers() => [
    "088", "091", "094",
    "083", "084", "085", "081", "082",
  ];

  static List<String> mobiPhonePrefixNumbers() => [
    "089", "090", "093",
    "070", "079", "077", "076", "078",
  ];

  static List<String> vietNamMobilePrefixNumbers() => [
    "092", "056", "058",
  ];
}
