import type { ITerminalProvider, TerminalProviderSeverity } from './ITerminalProvider';
/**
 * Terminal provider that stores written data in buffers separated by severity.
 * This terminal provider is designed to be used when code that prints to a terminal
 * is being unit tested.
 *
 * @beta
 */
export declare class NoOpTerminalProvider implements ITerminalProvider {
    /**
     * {@inheritDoc ITerminalProvider.write}
     */
    write(data: string, severity: TerminalProviderSeverity): void;
    /**
     * {@inheritDoc ITerminalProvider.eolCharacter}
     */
    get eolCharacter(): string;
    /**
     * {@inheritDoc ITerminalProvider.supportsColor}
     */
    get supportsColor(): boolean;
}
//# sourceMappingURL=NoOpTerminalProvider.d.ts.map